'use strict';
// get theme names and theme classes from theme.css
//TODO pull this out to a function that can be used by both search_files.js and config.js
let themes = {};
// get rules from theme.css and custom.css
let theme_stylesheets_rule_lists = [];
for (let i = 0; i < document.styleSheets.length; i++) {
	let stylesheet = document.styleSheets[i];
	if (stylesheet.href && 'custom.css' == stylesheet.href.substring(stylesheet.href.length - 10)) {
		theme_stylesheets_rule_lists.push(stylesheet.cssRules);
	}
	else if (stylesheet.cssRules[0].href && 'theme.css' == stylesheet.cssRules[0].href.substring(stylesheet.cssRules[0].href.length - 9)) {
		theme_stylesheets_rule_lists.push(stylesheet.cssRules[0].styleSheet.rules);
	}
}
for (let i = 0; i < theme_stylesheets_rule_lists.length; i++) {
	let rule_list = theme_stylesheets_rule_lists[i];
	for (let j = 0; j < rule_list.length; j++) {
		let rule = rule_list[j];
		if ('--name' == rule.style[0]) {
			let theme_index = rule.selectorText.indexOf('.theme-');
			if (-1 == theme_index) {
				continue;
			}
			let theme_id = rule.selectorText.substring(theme_index + 7);
			let theme_name = rule.style.getPropertyValue('--name');
			// trim whitespace from theme name
			theme_name = theme_name.trim();
			// trim quotes from theme name
			theme_name = theme_name.replace(/^\"+|\"+$/g, '');
			// trim single quotes from theme name
			theme_name = theme_name.replace(/^\'+|\'+$/g, '');
			// replace escaped characters
			theme_name = theme_name.replace('\\', '');
			themes[theme_id] = theme_name;
		}
	}
}

// replace text site theme input with select site theme input
let site_theme_input = document.querySelector('#config-site_theme');

let theme_select = document.createElement('select');
theme_select.id = 'config-site_theme';
theme_select.name = 'config_site_theme';
let option = document.createElement('option');
for (let theme in themes) {
	let option = document.createElement('option');
	option.value = theme;
	option.innerText = themes[theme];
	if (site_theme_input.value == theme) {
		option.selected = true;
	}
	theme_select.appendChild(option);
}

let site_theme_label = document.querySelector('[for=config-site_theme]');
site_theme_input.remove();
site_theme_label.parentNode.insertBefore(theme_select, site_theme_label.nextSibling);
