'use strict';
// filtered tags
function hide_filtered_tags(tags_string) {
	let filtered_tags = tags_from_string(tags_string);
	let thumbnails = document.querySelectorAll('.thumbnail');
	for (let i = 0; i < thumbnails.length; i++) {
		let thumbnail = thumbnails[i];
		if (thumbnail.classList.contains('current')) {
			continue;
		}
		thumbnail.classList.remove('filtered');
		let file_tags = tags_from_string(thumbnail.dataset.tags);
		for (let j in file_tags) {
			let file_tag = file_tags[j];
			if (filtered_tags.includes(file_tag)) {
				thumbnail.classList.add('filtered');
				break;
			}
		}
	}
}
hide_filtered_tags(localStorage.getItem('filtered-tags'));
