'use strict';
// set defaults if no local storage preferences
// fit files vertically defaults to 1
let preference_fit_files_vertically = localStorage.getItem('fit-files-vertically');
if (null == preference_fit_files_vertically) {
	localStorage.setItem('fit-files-vertically', 1);
}
// filtered tags defaults to the contents of html.data-default-filtered-tags
let preference_filtered_tags = localStorage.getItem('filtered-tags');
if (null == preference_filtered_tags) {
	localStorage.setItem('filtered-tags', document.documentElement.getAttribute('data-default-filtered-tags'));
}
// hide filtered tags defaults to the contents of html.data-default-hide-filtered
let preference_hide_filtered = localStorage.getItem('hide-filtered');
if (null == preference_hide_filtered) {
	let default_hide_filtered = document.documentElement.getAttribute('data-default-hide-filtered');
	localStorage.setItem('hide-filtered', default_hide_filtered);
}

// change theme
function change_theme(theme) {
	if ('' == theme) {
		theme = document.documentElement.dataset.theme.substr(6);
	}
	for (let i = document.documentElement.classList.length - 1; i > -1; i--) {
		let value = document.documentElement.classList[i];
		if ('theme-' == value.substr(0, 6)) {
			document.documentElement.classList.remove(value);
		}
	}
	document.documentElement.classList.add('theme-' + theme);
}
let preferred_theme = localStorage.getItem('theme');
if (preferred_theme) {
	change_theme(preferred_theme);
}

// boolean class-based local storage preferences
let preferences_toggle_ids = [
	'hide-filtered',
	'preview-filtered',
	'jumbo-thumbnails',
	'uncropped-thumbnails',
	'fit-files-vertically',
	'show-r18',
];
for (let i in preferences_toggle_ids) {
	let preference_toggle_id = preferences_toggle_ids[i];
	if (Number(localStorage.getItem(preference_toggle_id))) {
		document.documentElement.classList.add(preference_toggle_id);
	}
}
