'use strict';

// sequence navigation
import { SequenceNavigation } from './sequence_navigation.js';

new SequenceNavigation(document.querySelector('#prev-page'), document.querySelector('#next-page'));

// tags this page toggle
let tags_this_page = document.querySelector('#tags-this-page');
if (tags_this_page) {
	tags_this_page.classList.add('hidden');
	if (tags_this_page) {
		document.querySelector('#tags-this-page h2').addEventListener('click', e => {
			tags_this_page.classList.toggle('hidden');
		});
	}
}

// dim shade for preferences (and mass management later)
let dim = document.createElement('div');
dim.id = 'dim';
document.body.appendChild(dim);
dim.addEventListener('click', e => {
	document.body.classList.remove('preferences-open');
});

// preferences link
let preferences_link = document.createElement('a');
preferences_link.id = 'preferences-link';
preferences_link.innerText = 'Preferences';
preferences_link.addEventListener('click', e => {
	document.body.classList.add('preferences-open');
});
// preferences form
let preferences = document.createElement('form');
preferences.id = 'preferences';
document.body.appendChild(preferences);

// get theme names and theme classes from theme.css
//TODO pull this out to a function that can be used by both search_files.js and config.js
let themes = {};
// get rules from theme.css and custom.css
let theme_stylesheets_rule_lists = [];
for (let i = 0; i < document.styleSheets.length; i++) {
	let stylesheet = document.styleSheets[i];
	let style_href = '';
	let stylesheet_rules = null;
	if (stylesheet.href) {
		style_href = stylesheet.href;
		stylesheet_rules = stylesheet.cssRules;
	}
	if (stylesheet.cssRules && stylesheet.cssRules[0].href) {
		style_href = stylesheet.cssRules[0].href;
		stylesheet_rules = stylesheet.cssRules[0].styleSheet.rules;
	}
	if (!style_href || !stylesheet_rules) {
		continue;
	}
	// strip off query string if present
	let qmark_position = style_href.indexOf('?');
	if (-1 != qmark_position) {
		style_href = style_href.substring(0, qmark_position);
	}
	if ('custom/style.css' == style_href.substring(style_href.length - 16) || 'theme.css' == style_href.substring(style_href.length - 9)) {
		theme_stylesheets_rule_lists.push(stylesheet_rules);
	}
}
for (let i = 0; i < theme_stylesheets_rule_lists.length; i++) {
	let rule_list = theme_stylesheets_rule_lists[i];
	for (let j = 0; j < rule_list.length; j++) {
		let rule = rule_list[j];
		if ('--name' == rule.style[0]) {
			let theme_index = rule.selectorText.indexOf('.theme-');
			if (-1 == theme_index) {
				continue;
			}
			let theme_id = rule.selectorText.substring(theme_index + 7);
			let theme_name = rule.style.getPropertyValue('--name');
			// trim whitespace from theme name
			theme_name = theme_name.trim();
			// trim quotes from theme name
			theme_name = theme_name.replace(/^\"+|\"+$/g, '');
			// trim single quotes from theme name
			theme_name = theme_name.replace(/^\'+|\'+$/g, '');
			// replace escaped characters
			theme_name = theme_name.replace('\\', '');
			themes[theme_id] = theme_name;
		}
	}
}

let theme_label = document.createElement('label');
theme_label.setAttribute('for', 'theme');
theme_label.innerText = 'Site theme';
let theme_select = document.createElement('select');
theme_select.id = 'theme';
let option = document.createElement('option');
option.value = '';
option.innerText = 'Default';
theme_select.appendChild(option);
for (let theme in themes) {
	let option = document.createElement('option');
	option.value = theme;
	option.innerText = themes[theme];
	if (localStorage.getItem('theme') == theme) {
		option.selected = true;
	}
	theme_select.appendChild(option);
}
theme_select.addEventListener('change', e => {
	// save theme
	if ('' == e.currentTarget.value) {
		localStorage.removeItem('theme');
	}
	else {
		localStorage.setItem('theme', e.currentTarget.value);
	}
	change_theme(e.currentTarget.value);
});
preferences.appendChild(theme_label);
preferences.appendChild(theme_select);

// tags field
import { TagsField } from './tagsfield.js';

// search tags field
let search_input = document.querySelector('[name="tags"]');
if (search_input) {
	let target_form = search_input.parentNode;
	let disallowed_search_tag_prefixes = [];
	// create tags field
	let tags_field = new TagsField(
		disallowed_search_tag_prefixes,
		search_input.placeholder,
		search_input.dataset.removeTag,
		search_input.value
	);
	tags_field.search_input = search_input;
	// add classes to tags field components
	tags_field.preview.classList.add('tags-preview');
	// wrap tags field preview
	let preview_wrapper = document.createElement('div');
	preview_wrapper.classList.add('tags-preview-wrapper');
	if (0 == tags_field.tags_list.length) {
		preview_wrapper.classList.add('empty');
	}
	preview_wrapper.append(tags_field.preview);
	// add tags field components to target form
	target_form.insertBefore(preview_wrapper, tags_field.search_input);
	target_form.insertBefore(tags_field.input, tags_field.search_input);
	tags_field.input.placeholder = 'Tag search';

	// add submit listener to target form
	target_form.addEventListener('submit', e => {
		if (tags_field.input.value) {
			// commit any tag still in input
			tags_field.add_tags(tags_field.to_list(tags_field.input.value));
			tags_field.clear_input();
		}
		search_input.value = tags_field.to_string(tags_field.tags_list);
	});
	// add listener to swap negation and regular tags
	tags_field.input.addEventListener('added', e => {
		preview_wrapper.classList.remove('empty');
		if ('-' == e.detail.tag[0]) {
			tags_field.remove_tag(e.detail.tag.substring(1));
		}
		else {
			tags_field.remove_tag('-' + e.detail.tag);
		}
	});
	// add listener for clearing and removing
	tags_field.input.addEventListener('clear', e => {
		preview_wrapper.classList.add('empty');
	});
	tags_field.input.addEventListener('removed', e => {
		if (0 == tags_field.tags_list.length) {
			preview_wrapper.classList.add('empty');
		}
	});

	// listener for search hotkey
	window.addEventListener('keydown', e => {
		if (
			'INPUT' == document.activeElement.tagName
			|| 'TEXTAREA' == document.activeElement.tagName
		) {
			return;
		}
		if ('`' == e.key) {
			setTimeout(() => {
				tags_field.input.focus();
			}, 1);
		}
	});
	// listeners for add and negate tags on tags this page actions
	let actions = document.querySelectorAll('#tags-this-page .action');
	for (let i = 0; i < actions.length; i++) {
		let action = actions[i];
		actions[i].addEventListener('click', e => {
			e.preventDefault();
			if (actions[i].classList.contains('add')) {
				tags_field.add_tag(e.currentTarget.parentNode.dataset.tag);
			}
			else if (actions[i].classList.contains('remove')) {
				tags_field.add_tag('-' + e.currentTarget.parentNode.dataset.tag);
			}
		});
	}

	// only fetch tag suggestions on first search input focus
	tags_field.input.addEventListener('focus', e => {
		if (e.currentTarget.hasOwnProperty('fetched')) {
			return;
		}
		e.currentTarget.fetched = true;
		// fetch suggestions
		tags_field.fetch_suggestions();
	});

	// max search tags limit
	let max_tags = parseInt(search_input.dataset.maxTags);
	tags_field.input.addEventListener('added', e => {
		if (max_tags < e.currentTarget.tag_editor.tags_list.length) {
			alert(search_input.dataset.tooManyTags);
			e.currentTarget.tag_editor.remove_tag(e.detail.tag);
		}
	});

	// add a wrapper for tag suggestions
	let tag_suggestions_list_wrapper = document.createElement('div');
	tag_suggestions_list_wrapper.classList.add('tag-suggestions-list-wrapper');
	tags_field.input.parentNode.insertBefore(tag_suggestions_list_wrapper, tags_field.input.nextSibling);

	// on search input focus move tag suggestions element after it
	tags_field.input.addEventListener('focus', e => {
		tag_suggestions_list_wrapper.appendChild(tags_field.tag_suggestions_list);
	});
}

// filter tags
function set_negate_tags_cookie() {
	let filtered_tags = '#';
	if ('1' == localStorage.getItem('hide-filtered')) {
		filtered_tags = localStorage.getItem('filtered-tags').replaceAll(';', '');
	}
	let expires_date = new Date();
	expires_date.setFullYear( expires_date.getFullYear() + 10 );
	document.cookie = 'negate-tags=' + filtered_tags + '; expires=' + expires_date.toUTCString() + '; path=/';
}
let filtered_tags_label = document.createElement('label');
filtered_tags_label.setAttribute('for', 'filtered-tags');
filtered_tags_label.innerText = 'Filtered tags';
filtered_tags_label.title = 'Hide files with these tags';
let filtered_tags_input = document.createElement('input');
filtered_tags_input.id = 'filtered-tags';
filtered_tags_input.value = localStorage.getItem('filtered-tags');
filtered_tags_input.placeholder = '#vore #guro #etc';
filtered_tags_input.addEventListener('keydown', e => {
	if ('Enter' == e.key) {
		localStorage.setItem('filtered-tags', filtered_tags_input.value);
		set_negate_tags_cookie();
		hide_filtered_tags(filtered_tags_input.value);
	}
});
filtered_tags_input.addEventListener('focusout', e => {
	localStorage.setItem('filtered-tags', filtered_tags_input.value);
	hide_filtered_tags(filtered_tags_input.value);
});
preferences.appendChild(filtered_tags_label);
preferences.appendChild(filtered_tags_input);
preferences.appendChild(document.createElement('br'));

// search preferences
let preferences_toggles = {
	'hide-filtered': ['Hide filtered entirely', 'Hide filtered entirely'],
	'preview-filtered': ['Preview filtered', 'Hover filtered files warning thumbnail to preview them'],
	'jumbo-thumbnails': ['Jumbo thumbnails', 'Increase thumbnail size'],
	'uncropped-thumbnails': ['Uncropped thumbnails', 'Show uncropped thumbnails'],
	'fit-files-vertically': ['Fit files vertically', 'Fit tall files within the page'],
	'show-r18': ['Unblur R-18', 'Show unblurred R-18 thumbnails'],
};

for (let preference_id in preferences_toggles) {
	let preference_label = document.createElement('label');
	preference_label.innerText = preferences_toggles[preference_id][0];
	preference_label.title = preferences_toggles[preference_id][1];
	preference_label.setAttribute('for', preference_id);
	let preference_input = document.createElement('input');
	preference_input.id = preference_id;
	preference_input.type = 'checkbox';
	if (Number(localStorage.getItem(preference_id))) {
		preference_input.checked = true;
	}
	preference_input.addEventListener('change', e => {
		if (e.target.checked) {
			localStorage.setItem(e.target.id, 1);
			document.documentElement.classList.add(e.target.id);
		}
		else {
			localStorage.setItem(e.target.id, 0);
			document.documentElement.classList.remove(e.target.id);
		}
		if ('hide-filtered' == e.target.id) {
			set_negate_tags_cookie();
		}
	});
	preferences.appendChild(preference_input);
	preferences.appendChild(preference_label);
	preferences.appendChild(document.createElement('br'));
}

// restore defaults
let preferences_reset = document.createElement('input');
preferences_reset.type = 'button';
preferences_reset.value = 'Restore defaults';
preferences_reset.addEventListener('click', e => {
	e.preventDefault();
	// theme
	localStorage.removeItem('theme');
	change_theme('');
	theme_select.value = '';
	// filtered tags
	localStorage.setItem('filtered-tags', document.documentElement.getAttribute('data-default-filtered-tags'));
	hide_filtered_tags(document.documentElement.getAttribute('data-default-hide-filtered'));
	document.querySelector('#filtered-tags').value = document.documentElement.getAttribute('data-default-filtered-tags');
	// toggles
	for (let preference_toggle_id in preferences_toggles) {
		localStorage.removeItem(preference_toggle_id);
		document.querySelector('#' + preference_toggle_id).checked = false;
		document.documentElement.classList.remove(preference_toggle_id);
	}
	localStorage.setItem('fit-files-vertically', 1);
	document.querySelector('#fit-files-vertically').checked = true;
	document.documentElement.classList.add('fit-files-vertically');
	if ('1' == document.documentElement.getAttribute('data-default-hide-filtered')) {
		localStorage.setItem('hide-filtered', 1);
		document.querySelector('#hide-filtered').checked = true;
	}
});
preferences.appendChild(preferences_reset);

// consume form submit
preferences.addEventListener('submit', e => {
	e.preventDefault();
});

// add form and link to document
document.body.appendChild(preferences);

document.querySelector('#search-files-navigation').appendChild(preferences_link);

// thumbnail previews
import { add_thumbnail_preview } from './thumbnail_preview.js';
let thumbnails = document.querySelectorAll('.thumbnail');
for (let i = 0; i < thumbnails.length; i++) {
	let thumbnail = thumbnails[i];
	add_thumbnail_preview(thumbnail);
}

// refresh negate tags cookie every page view
set_negate_tags_cookie();
