'use strict';
// get theme names and theme classes from theme.css
//TODO pull this out to a function that can be used by both search_files.js and config.js
let themes = {};
// get rules from theme.css and custom.css
let theme_stylesheets_rule_lists = [];
for (let i = 0; i < document.styleSheets.length; i++) {
	let stylesheet = document.styleSheets[i];
	let style_href = '';
	let stylesheet_rules = null;
	if (stylesheet.href) {
		style_href = stylesheet.href;
		stylesheet_rules = stylesheet.cssRules;
	}
	if (stylesheet.cssRules && stylesheet.cssRules[0].href) {
		style_href = stylesheet.cssRules[0].href;
		stylesheet_rules = stylesheet.cssRules[0].styleSheet.rules;
	}
	if (!style_href || !stylesheet_rules) {
		continue;
	}
	// strip off query string if present
	let qmark_position = style_href.indexOf('?');
	if (-1 != qmark_position) {
		style_href = style_href.substring(0, qmark_position);
	}
	if ('custom/style.css' == style_href.substring(style_href.length - 16) || 'theme.css' == style_href.substring(style_href.length - 9)) {
		theme_stylesheets_rule_lists.push(stylesheet_rules);
	}
}
for (let i = 0; i < theme_stylesheets_rule_lists.length; i++) {
	let rule_list = theme_stylesheets_rule_lists[i];
	for (let j = 0; j < rule_list.length; j++) {
		let rule = rule_list[j];
		if ('--name' == rule.style[0]) {
			let theme_index = rule.selectorText.indexOf('.theme-');
			if (-1 == theme_index) {
				continue;
			}
			let theme_id = rule.selectorText.substring(theme_index + 7);
			let theme_name = rule.style.getPropertyValue('--name');
			// trim whitespace from theme name
			theme_name = theme_name.trim();
			// trim quotes from theme name
			theme_name = theme_name.replace(/^\"+|\"+$/g, '');
			// trim single quotes from theme name
			theme_name = theme_name.replace(/^\'+|\'+$/g, '');
			// replace escaped characters
			theme_name = theme_name.replace('\\', '');
			themes[theme_id] = theme_name;
		}
	}
}

// replace text site theme input with select site theme input
let site_theme_input = document.querySelector('#config-site_theme');

let theme_select = document.createElement('select');
theme_select.id = 'config-site_theme';
theme_select.name = 'config_site_theme';
let option = document.createElement('option');
for (let theme in themes) {
	let option = document.createElement('option');
	option.value = theme;
	option.innerText = themes[theme];
	if (site_theme_input.value == theme) {
		option.selected = true;
	}
	theme_select.appendChild(option);
}

let site_theme_label = document.querySelector('[for=config-site_theme]');
site_theme_input.remove();
site_theme_label.parentNode.insertBefore(theme_select, site_theme_label.nextSibling);
