<?php 
# a reference implementation of a thalassa web-based api written in php

include('thalassa_cli_interface.php');

# all responses from api should be json
header('Content-Type: application/json; charset=utf-8');

function populate_file_records_thumbnails($file_records) {
	foreach ($file_records as $file_id => $file_record) {
		$file_records[$file_id]['thumbnail'] = minify(render_thumbnail($file_record, $file_records));
	}
	return $file_records;
}
function send_output_error_response($result_output, $server_errors=[]) {
	$errors = [];
	foreach ($result_output as $error) {
		if (in_array($error, $server_errors)) {
			send_response('["' . $error . '"]', 500);
		} 
		array_push($errors, $error);
	}
	send_response(json_encode($errors), 400);
}
function send_file_search_response($file_ids) {
	$tags_string = '';
	foreach ($file_ids as $file_id) {
		$tags_string .= '#id:' . $file_id;
	}
	list($result_code, $result_output) = search_files($tags_string, -1);

	$search_files_result = parse_search_files_output($result_output);
	$search_files_result['file_records'] = populate_file_records_thumbnails($search_files_result['file_records']);

	send_response(json_encode($search_files_result));
}

if (!array_key_exists('endpoint', $_GET)) {
	send_response('["No endpoint provided"]', 400);
}
$endpoint = $_GET['endpoint'];

if ((!AUTHORIZED || !in_array(TOKEN_MODE, ['admin', 'helper'])) && !in_array($endpoint, ['sign_in', 'search', 'view'])) {
	# not authorized or not admin or helper and trying to access anything except sign in, search, or view file
	send_response('["Authorization required"]', 403);
}
elseif ('helper' == TOKEN_MODE && ('edit_files_tags' != $endpoint || !array_key_exists('tag_mode', $_POST) || 'add' != $_POST['tag_mode'])) {
	# helper only and trying to access anything other than add tag
	send_response('["Authorization required"]', 403);
}

# pass
if ('set_first_pass' == $endpoint) {
	initialize_post_keys(['new_pass', 'new_pass_confirmation']);
	list($result_code, $result_output) = set_first_pass($_POST['new_pass'], $_POST['new_pass_confirmation']);
	if (0 == $result_code) {
		# return access token
		send_response('[": "' . $result_output[1] . '"]');
	}
	send_output_error_response($result_output, ['Problem writing pass hash', 'Problem creating tables', 'Problem initializing database']);
}
elseif ('check_pass' == $endpoint) {
	initialize_post_keys(['pass']);
	list($result_code, $result_output) = check_pass($_POST['pass']);
	if (0 == $result_code) {
		# return access token
		send_response('["' . $result_output[1] . '"]');
	}
	send_output_error_response($result_output);
}
elseif ('change_pass' == $endpoint) {
	initialize_post_keys(['current_pass', 'new_pass', 'new_pass_confirmation']);
	list($result_code, $result_output) = change_pass($_POST['current_pass'], $_POST['new_pass'], $_POST['new_pass_confirmation']);
	if (0 == $result_code) {
		send_response('["Successfully changed pass"]');
	}
	send_output_error_response($result_output, ['Problem reading pass hash', 'Pass not set', 'Problem writing pass hash']);
}

# token
elseif ('check_token' == $endpoint) {
	initialize_post_keys(['token']);
	list($result_code, $result_output) = check_token($_POST['token']);
	if (0 == $result_code) {
		send_response('["Valid token"]');
	}
	send_output_error_response($result_output);
}
elseif ('list_tokens' == $endpoint) {
	$tokens = list_tokens();
	send_response(json_encode($tokens));
}
elseif ('write_new_token' == $endpoint) {
	list($result_code, $result_output) = write_new_token();
	if (0 == $result_code) {
		# return access token
		send_response('["' . $result_output[1] . '"]');
	}
	send_output_error_response($result_output, ['Problem writing tokens']);
}
elseif ('set_helper_tokens' == $endpoint) {
	if (!array_key_exists('tokens', $_POST) || '' == $_POST['tokens']) {
		send_response('["No tokens provided"]', 400);
	}
	$helper = true;
	if (!array_key_exists('helper', $_POST) || '' == $_POST['helper']) {
		$helper = false;
	}
	list($result_code, $result_output) = set_helper_tokens($_POST['tokens']);
	if (0 == $result_code) {
		send_response('["Successfully set tokens helper status"]');
	}
	send_output_error_response($result_output, ['Problem writing tokens']);
}
elseif ('set_token_name' == $endpoint) {
	if (!array_key_exists('token', $_POST) || '' == $_POST['token']) {
		send_response('["No token provided"]', 400);
	}
	$name = '';
	if (array_key_exists('name', $_POST)) {
		$name = $_POST['name'];
	}
	list($result_code, $result_output) = set_token_name($_POST['token'], $name);
	if (0 == $result_code) {
		send_response('["Successfully set token name status"]');
	}
	send_output_error_response($result_output, ['Problem writing tokens']);
}
elseif ('remove_tokens' == $endpoint) {
	if (!array_key_exists('tokens', $_POST) || '' == $_POST['tokens']) {
		send_response('["No tokens provided"]', 400);
	}
	list($result_code, $result_output) = remove_tokens($_POST['tokens']);
	if (0 == $result_code) {
		send_response('["Successfully removed tokens"]');
	}
	send_output_error_response($result_output, ['Problem writing tokens']);
}

# database
elseif ('initialize_database' == $endpoint) {
	list($result_code, $result_output) = initialize_database();
	if (0 == $result_code) {
		send_response('["Successfully initialized database"]');
	}
	send_output_error_response($result_output, ['Problem creating tables', 'Problem initializing database']);
}

# files
elseif ('store_files' == $endpoint) {
	initialize_post_keys(['datetime', 'tags', 'comma_separated_tags', 'tag_filename', 'title', 'description']);

	# postybirb doesn't allow for a custom tag separator
	# and will always send comma-separated tags
	# and also doesn't allow for custom post fields
	# so allow a custom header to enable comma separated tags
	if (array_key_exists('HTTP_X_COMMA_SEPARATED_TAGS', $_SERVER)) {
		$_POST['comma_separated_tags'] = true;
	}

	$res = ['file_records' => null, 'upload_errors' => [], 'fetch_errors' => []];

	$temp_file_paths = [];
	$problem_upload_files = [];
	$problem_fetch_files = [];
	# file upload
	if (
		array_key_exists('file_upload', $_FILES)
		&& 0 < count($_FILES['file_upload']['name'])
		&& !empty($_FILES['file_upload']['name'][0])
	) {
		list($new_temp_file_paths, $problem_upload_files) = preprocess_uploaded_files($_FILES['file_upload']);
		$temp_file_paths = array_merge($temp_file_paths, $new_temp_file_paths);
		foreach ($problem_upload_files as $problem_upload_file) {
			$filename = $problem_upload_file[0];
			$error = $problem_upload_file[1];
			array_push($res['upload_errors'], $filename . ' (' . $error . ')');
		}
	}
	# file fetch
	if (array_key_exists('file_fetch', $_POST)) {
		$file_urls = [];
		if (false !== strpos($_POST['file_fetch'], ',')) {
			$file_urls = explode(',', trim($file_urls, ','));
		}
		else {
			$file_urls = [$_POST['file_fetch']];
		}
		list($new_temp_file_paths, $problem_fetch_files) = preprocess_fetched_files($file_urls);
		$temp_file_paths = array_merge($temp_file_paths, $new_temp_file_paths);
		foreach ($problem_fetch_files as $file_url) {
			array_push($res['fetch_errors'], $file_url);
		}
	}

	list($result_code, $result_output) = process_temp_files(
		$temp_file_paths,
		$_POST['datetime'],
		$_POST['tags'],
		$_POST['comma_separated_tags'],
		$_POST['tag_filename'],
		$_POST['title'],
		$_POST['description']
	);

	$possible_store_file_errors = [
		'Problem moving file to destination' => 'problem-moving-file',
		'File already exists' => 'file-already-exists',
		'Thumbnail not created' => 'thumbnail-not-created',
		'Thumbnail video clip not created' => 'thumbnail-video-clip-not-created',
	];
	$file_records = [];
	for ($i = 0; $i < count($result_output); $i += 2) {
		$file_record = parse_file_record_string($result_output[$i]);
		$errors = explode("\t", $result_output[$i + 1]);
		if (0 < count($errors)) {
			foreach ($errors as $error) {
				if (array_key_exists($error, $possible_store_file_errors)) {
					array_push($file_record['errors'], $error);
				}
			}
		}
		array_push($file_records, $file_record);
	}
	$res['file_records'] = populate_file_records_thumbnails($file_records);
	send_response(json_encode($res));
}
elseif ('remove_files' == $endpoint) {
	if (!array_key_exists('file_ids', $_POST) || '' == $_POST['file_ids']) {
		send_response('["No file IDs provided"]', 400);
	}
	list($result_code, $result_output) = remove_files($_POST['file_ids']);
	if (0 == $result_code) {
		$file_ids = explode(',', $_POST['file_ids']);
		$res = ['file_records' => []];
		foreach ($file_ids as $file_id) {
			$res['file_records'][$file_id] = ['remove' => true];
		}
		send_response(json_encode($res));
	}
	send_output_error_response($result_output);
}
elseif ('set_publish_time' == $endpoint) {
	if (!array_key_exists('file_ids', $_POST) || '' == $_POST['file_ids']) {
		send_response('["No file IDs provided"]', 400);
	}
	if (!array_key_exists('datetime', $_POST)) {
		send_response('["No datetime provided"]', 400);
	}
	list($result_code, $result_output) = set_publish_time($_POST['file_ids'], $_POST['datetime']);
	if (0 == $result_code) {
		send_file_search_response(explode(',', $_POST['file_ids']));
	}
	send_output_error_response($result_output);
}
elseif ('rebuild_files' == $endpoint) {
	if (!array_key_exists('file_ids', $_POST) || '' == $_POST['file_ids']) {
		send_response('["No file IDs provided"]', 400);
	}
	list($result_code, $result_output) = rebuild_files($_POST['file_ids']);
	if (0 == $result_code) {
		send_file_search_response(explode(',', $_POST['file_ids']));
	}
	send_output_error_response($result_output);
}
elseif ('search_files' == $endpoint) {
	$tags_string = '';
	if (array_key_exists('tags', $_POST)) {
		$tags_string = $_POST['tags'];
		$tags_string = format_tags_string($tags_string);
	}
	$page = 0;
	if (array_key_exists('page', $_POST)) {
		$page = $_POST['page'];
	}

	list($result_code, $result_output) = search_files($tags_string, $page);

	$search_files_result = parse_search_files_output($result_output);
	$search_files_result['file_records'] = populate_file_records_thumbnails($search_files_result['file_records']);

	send_response(json_encode($search_files_result));
}
elseif ('edit_files_tags' == $endpoint) {
	if (!array_key_exists('file_ids', $_POST) || '' == $_POST['file_ids']) {
		send_response('["No file IDs provided"]', 400);
	}
	$mode = 'replace';
	if (array_key_exists('tag_mode', $_POST) && in_array($_POST['tag_mode'], ['replace', 'remove', 'add'])) {
		$mode = $_POST['tag_mode'];
	}
	$tags_string = '';
	if (array_key_exists('tags', $_POST)) {
		$tags_string = $_POST['tags'];
	}
	$comma_separated_tags = false;
	if (array_key_exists('comma_separated_tags', $_POST) && '' != $_POST['comma_separated_tags']) {
		$comma_separated_tags = true;
	}
	list($result_code, $result_output) = edit_files_tags($_POST['file_ids'], $mode, $tags_string, $comma_separated_tags);
	if (0 == $result_code) {
		send_file_search_response(explode(',', $_POST['file_ids']));
	}
	send_output_error_response($result_output, ['Problem removing tags', 'Problem adding tags']);
}
elseif ('generate_set' == $endpoint) {
	if (!array_key_exists('file_ids', $_POST) || '' == $_POST['file_ids']) {
		send_response('["No file IDs provided"]', 400);
	}
	$sync = false;
	if (array_key_exists('sync', $_POST) && '' != $_POST['sync']) {
		$sync = true;
	}
	list($result_code, $result_output) = generate_set($_POST['file_ids'], $sync);
	if (0 == $result_code) {
		send_file_search_response(explode(',', $_POST['file_ids']));
	}
	send_output_error_response($result_output, ['Problem removing tags', 'Problem adding tags']);
}
# tags
elseif ('list_tags' == $endpoint) {
	$tags = list_tags();
	send_response(json_encode($tags));
}
elseif ('generate_tag_suggestions' == $endpoint) {
	generate_tag_suggestions();
	send_response('["Successfully generated tag suggestions"]');
}
elseif ('remove_tags' == $endpoint) {
	if (!array_key_exists('tags', $_POST) || '' == $_POST['tags']) {
		send_response('["No tags to remove provided"]', 400);
	}
	$comma_separated_tags = false;
	if (array_key_exists('comma_separated_tags', $_POST) && '' != $_POST['comma_separated_tags']) {
		$comma_separated_tags = true;
	}
	remove_tags($_POST['tags'], $comma_separated_tags);
	send_response('["Successfully removed tags"]');
}
elseif ('replace_tag' == $endpoint) {
	if (!array_key_exists('old_tag', $_POST) || '' == $_POST['old_tag']) {
		send_response('["No tag to replace provided"]', 400);
	}
	if (!array_key_exists('new_tag', $_POST) || '' == $_POST['new_tag']) {
		send_response('["No tag replacement provided"]', 400);
	}
	replace_tags($_POST['old_tag'], $_POST['new_tag']);
	send_response('["Successfully replaced tag"]');
}
elseif ('accompany_tag' == $endpoint) {
	if (!array_key_exists('tag', $_POST) || '' == $_POST['tag']) {
		send_response('["No tag to accompany provided"]', 400);
	}
	if (!array_key_exists('new_tag', $_POST) || '' == $_POST['new_tag']) {
		send_response('["No tag accompaniment provided"]', 400);
	}
	accompany_tags($_POST['tag'], $_POST['new_tag']);
	send_response('["Successfully accompanied tag"]');
}
#TODO
elseif ('cleanup' == $endpoint) {
	#TODO
}
else {
	$res = implode("\n", $_SERVER);
	send_response($res, 409);
	send_response('Invalid mode', 400);
}
 ?>