<?php 
# check python3
$python3 = 'python';
$python3_found = false;
$result_code = null;
$result_output = null;
exec($python3 . ' --version', $result_output, $result_code);
if (0 == $result_code) {
	# check version
	$python_version = explode('.', str_replace('Python ', '', $result_output[0]));
	if ('3' == $python_version[0]) {
		$python3_found = true;
	}
}
if (!$python3_found) {
	$python3 = 'python3';
	$result_code = null;
	$result_output = null;
	exec($python3 . ' --version', $result_output, $result_code);
	if (0 == $result_code) {
		$python_version = explode('.', str_replace('Python ', '', $result_output[0]));
		if ('3' == $python_version[0]) {
			$python3_found = true;
		}
	}
}
if (!$python3_found) {
	print('Python 3 not found, please check with your system administrator');
	exit();
}

# check virtualenv
$virtualenv = 'virtualenv';
$virtualenv_found = false;
$result_code = null;
$result_output = null;
exec($python3 . ' -m ' . $virtualenv . ' --version', $result_output, $result_code);
if (0 != $result_code) {
	$virtualenv = 'venv';
	$result_code = null;
	$result_output = null;
	exec($python3 . ' -m ' . $virtualenv . ' --help', $result_output, $result_code);
	if (0 != $result_code) {
		print('Neither virtualenv nor venv modules found, please check with your system administrator');
		exit();
	}
}

# get current directory
define('PUBLIC_DIRECTORY', getcwd());

if (is_file(PUBLIC_DIRECTORY . DIRECTORY_SEPARATOR . 'installed')) {
	print('thalassa is already installed');
	exit();
}

function install_form($errors=[]) {
	$res = '';
	$username = 'your_username';
	$home_dir = DIRECTORY_SEPARATOR . 'home' . DIRECTORY_SEPARATOR;
	$home_dir_position = strpos(PUBLIC_DIRECTORY, $home_dir);
	if (false !== $home_dir_position) {
		$username = substr(PUBLIC_DIRECTORY, $home_dir_position + strlen($home_dir));
		$username = explode(DIRECTORY_SEPARATOR, $username)[0];
	}
	$res = '<!doctype html>
<html>
	<head>
		<title>Install thalassa</title>
		<link rel="stylesheet" type="text/css" href="./static/style/general.css"/>
		<link rel="stylesheet" type="text/css" href="./static/style/forms.css"/>
		<link rel="stylesheet" type="text/css" href="./static/style/theme.css"/>
		<style type="text/css">
			#content {
				width: 640px;
				margin: 0 auto;
			}
		</style>
	</head>
	<body>
		<div id="content">
			<section id="section-install">
				<h1>Install thalassa</h1>';
	foreach ($errors as $error) {
		$res .= '<p class="error">' . $error . '</p>';
	}
	$res .= '
				<p>
					Specify a private directory, which cannot be accessed from the website, 
					where the thalassa database and other sensitive files will be stored 
					<small>(e.g. /home/' . $username . '/private/thalassa)</small>
				</p>
				<form method="post">
					<label for="private-directory">Private directory</label> <input id="private-directory" name="private_directory" type="text"/>
					<br/>
					<input type="submit"/>
				</form>
				<p><small>This may take some time while creating the virtual environment</small></p>
			</section>
		</div>
	</body>
</html>';
	print($res);
	exit();
}

if ('POST' == $_SERVER['REQUEST_METHOD']) {
	$windows = false;
	# windows (are you really running a production webserver from windows?)
	if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
		$windows = true;
	}
	define('WINDOWS', $windows);

	if (
		!array_key_exists('private_directory', $_POST)
		|| '' == $_POST['private_directory']) {
		install_form(['Private directory not specified']);
	}
	define('PRIVATE_DIRECTORY', $_POST['private_directory']);

	# check if private directory exists
	if (!is_dir(PRIVATE_DIRECTORY)) {
		if (!mkdir(PRIVATE_DIRECTORY)) {
			install_form(['Problem creating private directory']);
		}
	}

	# copy .thalassa/ files to private directory
	mkdir(PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa');
	foreach (['thalassa.py', 'thalassa_cli.py', 'thalassa_config_example.json'] as $thalassa_file) {
		copy(
			PUBLIC_DIRECTORY . DIRECTORY_SEPARATOR . '.thalassa' . DIRECTORY_SEPARATOR . $thalassa_file, 
			PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa' . DIRECTORY_SEPARATOR . $thalassa_file
		);
	}

	$source_command = '. environment' . DIRECTORY_SEPARATOR . 'bin' . DIRECTORY_SEPARATOR . 'activate';
	if (WINDOWS) {
		$source_command = 'call environment' . DIRECTORY_SEPARATOR . 'Scripts' . DIRECTORY_SEPARATOR . 'activate.bat';
	}
	# create virtual environment in thalassa directory
	$result_output = null;
	$result_code = null;
	exec(
		'cd ' . escapeshellarg(PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa') . ' && ' . 
		$python3 . ' -m ' . $virtualenv . ' environment'
	);
	if (0 != $result_code && 'created' != substr($result_output[0], 0, 7)) {
		install_form(['Problem creating virtualenv']);
	}

	# install bcrypt and puremagic modules in virtualenv
	$result_output = null;
	$result_code = null;
	exec(
		'cd ' . escapeshellarg(PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa') . ' && ' .
		$source_command . ' && ' .
		$python3 . ' -m pip install bcrypt && ' .
		$python3 . ' -m pip install puremagic && ' .
		'deactivate',
		$result_output,
		$result_code
	);
	if (0 != $result_code && 'created' != substr($result_output[0], 0, 7)) {
		install_form(['Problem installing bcrypt and puremagic modules in virtualenv']);
	}

	# copy example thalassa config example to private directory
	if (!copy(PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa' . DIRECTORY_SEPARATOR . 'thalassa_config_example.json', PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa_config.json')) {
		install_form(['Problem copying example thalassa config']);
	}

	# copy thalassa_site config example
	if (!copy(PUBLIC_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa_site_config_example.json', PUBLIC_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa_site_config.json')) {
		install_form(['Problem copying example thalassa site config']);
	}

	# edit thalassa config
	$thalassa_config = json_decode(file_get_contents(PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa_config.json'), true);
	$thalassa_config['database_file_path'] = PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa_db.sqlite';
	$thalassa_config['log_file_path'] = PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa.log';
	$thalassa_config['files_directory_path'] = PUBLIC_DIRECTORY . DIRECTORY_SEPARATOR . 'files' . DIRECTORY_SEPARATOR;
	$thalassa_config['pass_hash_file_path'] = PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa_pass_hash.txt';
	$thalassa_config['tokens_file_path'] = PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa_tokens.json';
	#TODO other values in the thalassa config
	file_put_contents(PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa_config.json', json_encode($thalassa_config, JSON_PRETTY_PRINT));

	# edit thalassa_site config
	$thalassa_site_config = json_decode(file_get_contents(PUBLIC_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa_site_config.json'), true);
	if (WINDOWS) {
		$thalassa_site_config['python3_path'] = PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa' . DIRECTORY_SEPARATOR . 'environment' . DIRECTORY_SEPARATOR . 'Scripts' . DIRECTORY_SEPARATOR . 'python';
	}
	else {
		$thalassa_site_config['python3_path'] = PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa' . DIRECTORY_SEPARATOR . 'environment' . DIRECTORY_SEPARATOR . 'bin' . DIRECTORY_SEPARATOR . 'python';
	}
	$thalassa_site_config['thalassa_cli_path'] = PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa' . DIRECTORY_SEPARATOR . 'thalassa_cli.py';
	$thalassa_site_config['thalassa_config_path'] = PRIVATE_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa_config.json';
	file_put_contents(PUBLIC_DIRECTORY . DIRECTORY_SEPARATOR . 'thalassa_site_config.json', json_encode($thalassa_site_config, JSON_PRETTY_PRINT));

	# write ./installed
	file_put_contents(PUBLIC_DIRECTORY . DIRECTORY_SEPARATOR . 'installed', '');

	# initialize database
	$thalassa_cmd = $thalassa_site_config['python3_path'] . ' ' . $thalassa_site_config['thalassa_cli_path'] . ' --config=' . $thalassa_site_config['thalassa_config_path'];
	exec($thalassa_cmd . ' --initialize-database');

	# redirect to self
	header('Location: ' . $_SERVER['SCRIPT_URI']);
	print('<html><head><meta http-equiv="refresh" content="2; url=' . $_SERVER['SCRIPT_URI']  . '"/></head><body>install successful, redirecting to thalassa</body></html>');
	exit();
}

install_form();
 ?>