<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:atom="http://www.w3.org/2005/Atom">

	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
			</head>
			<body>
				<h1><xsl:value-of select="atom:feed/atom:title"/></h1>
				<h2><xsl:value-of select="atom:feed/atom:subtitle"/></h2>
				<p>generated by <a href="https://secret.graphics/projects/thalassa">thalassa</a></p>
				<table border="1">
					<thead>
						<tr>
							<th>Publish time</th>
							<th>Title</th>
							<th>Summary</th>
							<th>Thumbnail</th>
						</tr>
					</thead>
					<tbody>
						<xsl:for-each select="atom:feed/atom:entry">
							<tr>
								<td><xsl:value-of select="atom:published"/></td>
								<td><xsl:value-of select="atom:title"  disable-output-escaping="yes"/></td>
								<td><xsl:value-of select="atom:summary"  disable-output-escaping="yes"/></td>
								<td><xsl:value-of select="atom:content" disable-output-escaping="yes"/></td>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
				<script type="text/javascript" src="script/video_clips.js"/>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
