<?php 
function render_page_header($page_title, $page_id='', $opengraph=[], $misc='') {
	$page_title = CONFIG['site_title'] . ' - ' . $page_title;
	$page_title = str_replace('"', '&quot;', $page_title);

	$static_files_version = '2025-08-13_1027';
	$res = '<!doctype html>
<html 
	lang="en" 
	class="theme-' . CONFIG['site_theme'] . '" 
	data-theme="theme-' . CONFIG['site_theme'] . '" 
	data-default-filtered-tags="' . CONFIG['default_filtered_tags'] . '" 
	data-default-hide-filtered="' . (CONFIG['default_hide_filtered'] ? '1' : '0') . '">
	<head>
		<title>' . $page_title . '</title>
		<meta charset="utf8"/>
		<link rel="shortcut icon" type="image/x-icon" href="' . CONFIG['site_favicon_ico_uri'] . '"/>
		<link rel="shortcut icon" type="image/png" href="' . CONFIG['site_favicon_png_uri'] . '"/>
		<link rel="thalassa" href="' . THALASSA_URI . '"/>
		<link rel="files" href="' . THALASSA_URI . 'files/"/>
		<base href="' . THALASSA_URI . '"/>
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=4.0, minimum-scale=1.0, user-scalable=1.0"/>
		<meta property="og:site_name" content="' . CONFIG['site_name'] . '"/>
		<meta name="theme-color" content="' . CONFIG['site_color'] . '"/>
		<meta property="og:title" content="' . $page_title . '"/>
		<meta name="twitter:title" content="' . $page_title . '"/>
		<meta property="og:type" content="thalassa:' . $page_id . '"/>
		<meta name="twitter:card" content="summary_large_image"/>';
	$specified_image = false;
	foreach ($opengraph as $key => $content) {
		if ('property="og:image"' ) {
			$specified_image = true;
		}
		$res .= '<meta ' . $key . ' content="' . $content . '"/>';
	}
	if (!$specified_image) {
		$res .= '<meta property="og:image" content="' . CONFIG['site_image_uri'] . '"/>';
	}
	$res .= '<meta name="tag-suggestion-list" content="' . FILES_URI . 'tag_suggestions.json"/>';
	if (AUTHORIZED) {
		$res .= '
		<meta name="authorized" content="1"/>
		<meta name="tag-suggestion-list" content="' . FILES_URI . 'tag_suggestions_full.json"/>
		<link rel="api" href="' . THALASSA_URI . 'api/"/>';
		if ('helper' == TOKEN_MODE) {
			$res .= '
		<meta name="helper" content="1"/>';
		}
	}
	$res .= '<style type="text/css">@import \'' . STATIC_URI . 'style/theme.css?' . $static_files_version . '\';</style>';
	foreach (['general', 'tables', 'forms', 'depth', 'layout', 'topmenu', 'tags', 'files', 'script'] as $stylesheet) {
		$res .= '<link rel="stylesheet" type="text/css" href="' . STATIC_URI . 'style/' . $stylesheet . '.css?' . $static_files_version . '"/>';
	}
	$res .= '<link rel="stylesheet" type="text/css" href="custom/style.css?' . $static_files_version . '"/>';
	$res .= '<script type="text/javascript">document.documentElement.classList.add(\'scripts-enabled\');</script>';
	foreach (['general', 'preferences'] as $script) {	#, 'string_format'
		$res .= '<script type="text/javascript" src="' . STATIC_URI . 'script/' . $script . '.js?' . $static_files_version . '"></script>';
	}
	$res .= '<script type="module" src="custom/script.js?' . $static_files_version . '"></script>' . $misc . '
	</head>
	<body id="endpoint-' . $page_id . '">
		<nav id="topmenu">
			<a id="top-thalassa" href="' . THALASSA_URI . 'thalassa" title="thalassa file archive ' . THALASSA_INFO['thalassa_version'] . '">Thalassa</a> ';
	$home_uri = THALASSA_URI. 'home';
	if ('' != CONFIG['site_topmenu_home_uri']) {
		$home_uri = CONFIG['site_topmenu_home_uri'];
	}
	$res .= '<a id="top-home" href="' . $home_uri . '" title="Home">Home</a> ';
	$res .= '<a id="top-search" href="' . THALASSA_URI . 'search" title="Search files">' . CONFIG['site_topmenu_search_text'] . '</a> ';
	if (0 < count(CONFIG['additional_topmenu_items'])) {
		foreach (CONFIG['additional_topmenu_items'] as $topmenu_item) {
			$item_id = $topmenu_item['id'];
			$item_text = $topmenu_item['text'];
			$item_destination = $topmenu_item['destination'];
			$res .= '<a id="top-' . $item_id . '" href="' . $item_destination . '" title="' . $item_text . '">' . $item_text . '</a>';
		}
	}
	if (AUTHORIZED) {
		if ('admin' == TOKEN_MODE) {
			$res .= '
			<a id="top-store-files" href="' . THALASSA_URI . 'store" title="Store files">' . CONFIG['site_topmenu_store_files_text'] . '</a> 
			<a id="top-admin" href="' . THALASSA_URI . 'admin" title="Admin index">Admin</a> ';
		}
		$res .= '
			<a id="top-sign-out" href="' . THALASSA_URI . 'sign_out" title="Sign out">Sign out</a>';
	}
	else {
		$res .= '<a id="top-sign-in" href="' . THALASSA_URI . 'sign_in" title="Sign in">Sign in</a>';
	}
	$res .= '
		</nav>
		<div id="content">
			<section id="section-' . $page_id . '">';
	return $res;
}

define('PAGE_FOOTER', '
			</section>
		</div>
		<script type="text/javascript">setTimeout(() => {document.documentElement.classList.add(\'loading-finished\');}, 50);</script>
		<script type="text/javascript">console.log(\'%c thalassa %c file archive by %c secret \',\'background: black; color: white;\', \'background: white; color: black;\', \'background: #00c0ff; color: white;\');console.log(\'@ https://secret.graphics/projects/thalassa\');</script>
	</body>
</html>');

# functions to help render page components
function render_result_output_errors($errors) {
	$res = '';
	foreach ($errors as $error) {
		$res .= '<div class="error">' . $error . '</div>';
	}
	return $res;
}
function render_tag($tag) {
	$tag = str_replace('<', '&lt;', $tag);
	$tag = str_replace('"', '&quot;', trim($tag));
	$tag_prefix = '';
	$tag_postfix = $tag;
	$category_tag_prefixes = [
		'author:',
		'name:',
		'source:',
		'title:',
	];
	foreach ($category_tag_prefixes as $category_tag_prefix) {
		$prefix_length = strlen($category_tag_prefix);
		if ($category_tag_prefix == substr($tag_postfix, 0, $prefix_length)) {
			$tag_prefix = '<span class="tag-prefix">' . $category_tag_prefix . '</span>';
			$tag_postfix = substr($tag_postfix, $prefix_length);
			break;
		}
	}
	$rendered_tag = '<span class="tag" data-tag="' . $tag . '"><a href="' . THALASSA_URI . 'search?tags=' . $tag . '">#' . $tag_prefix . $tag_postfix . '</a></span> ';
	return $rendered_tag;
}
#TODO this should probably only be calculated in javascript clientside for local timezones
function render_atom_time($timestamp) {
	date_default_timezone_set('America/Los_Angeles');
	return date(DATE_ATOM_W_TZ, $timestamp);
}
function render_file_size($bytes, $precision=2) {
	$units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB'); 
	$factor = floor((strlen($bytes) - 1) / 3);
    return sprintf("%.{$precision}f", $bytes / pow(1024, $factor)) . ' ' . @$units[$factor];

	$bytes = max($bytes, 0); 
	$pow = floor(($bytes ? log($bytes) : 0) / log(1024)); 
	$pow = min($pow, count($units) - 1); 

	return round($bytes, $precision) . ' ' . $units[$pow]; 
}
function render_fuzzy_time($timestamp) {
	$now = new DateTime;
	$ago = new DateTime('@' . round($timestamp));
	$diff = $now->diff($ago);
	$time_direction = ' ago';
	if ($now < $ago) {
		$time_direction = ' from now';
	}

	$diff->w = floor($diff->d / 7);
	$diff->d -= $diff->w * 7;

	$string = [
		'y' => 'year',
		'm' => 'month',
		'w' => 'week',
		'd' => 'day',
		'h' => 'hour',
		'i' => 'minute',
		's' => 'second',
	];

	foreach ($string as $k => &$v) {
		if ($diff->$k) {
			$v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
		} else {
			unset($string[$k]);
		}
	}

	$string = array_slice($string, 0, 1);
	return $string ? implode(', ', $string) . $time_direction : 'just now';
}

# reused forms
define('FORM_FIRST_PASS', '
	<form method="post">
		<label for="new_pass">Pass</label> 
		<input type="password" id="new_pass" name="new_pass"/>
		<br/>
		<label for="new_pass_confirmation">Pass confirmation</label> 
		<input type="password" id="new_pass_confirmation" name="new_pass_confirmation"/>
		<br/>
		<input type="submit" value="Submit"/>
	</form>');

define('FORM_SIGN_IN', '
	<form method="post">
		<label for="pass">Pass</label> 
		<input type="password" id="pass" name="pass" placeholder="Pass"/>
		<br/>
		<input type="submit" value="Sign in"/>
	</form>');

define('FORM_CHANGE_PASS', '
	<form method="post">
		<label for="current-pass">Current pass</label> 
		<input type="password" id="current-pass" name="current_pass"/>
		<br/>
		<label for="new-pass">New pass</label> 
		<input type="password" id="new-pass" name="new_pass"/>
		<br/>
		<label for="new-pass-confirmation">Confirm new pass</label> 
		<input type="password" id="new-pass-confirmation" name="new_pass_confirmation"/>
		<br/>
		<input type="submit"/>
	</form>');
define('FORM_USE_TOKEN', '
	<p>Sign in with a valid access token.</p>
	<form method="post">
		<label for="token">Token</label> 
		<input type="text" id="token" name="token" placeholder="Token"/>
		<br/>
		<input type="submit"/>
	</form>');
define('FORM_STORE_FILES', '
	<form enctype="multipart/form-data" method="post">
		<label for="datetime">Publish datetime</label> 
		<input id="datetime" name="datetime" type="text" size="24" placeholder="Leave blank for current" value="' . CONFIG['default_publish_time_new_files'] . '"/>
		<br/>
		<label for="tags">Tags</label> 
		<input id="tags" name="tags" type="text" placeholder="#tag #another tag" size="23" value="' . format_tags_string(CONFIG['default_tags_new_files']) . '"/>
		<br/>
		<!--this doesn\'t need to be exposed input id="comma-separated-tags" name="comma_separated_tags" type="checkbox"/> 
		<label for="comma-separated-tags">Comma-separated tags</label>
		<br/ -->
		<input id="tag-filenames" name="tag_filenames" type="checkbox"' . (CONFIG['default_tag_filenames_new_files'] ? ' checked' : '') . '/> 
		<label for="tag-filenames" title="Add filename as tag">Tag filename</label>
		<br/>
		<label for="file-upload">Upload files</label> 
		<input id="file-upload" name="file_upload[]" type="file" multiple/>
		<br/>
		<label for="file-fetch">Fetch file</label> 
		<input id="file-fetch" name="file_fetch" type="text" placeholder="https://domain/path/file.ext" size="32"/>
		<br/>
		<input type="submit" value="Store files"/>
	</form>
	<script type="module" src="' . STATIC_URI . 'script/store_files.js"></script>');

function render_endpoint_thalassa() {
	return render_page_header('About thalassa', 'about-thalassa') . '
		<div class="card">
			<p><a href="https://secret.graphics/projects/thalassa">thalassa</a> is a stripped-down file archive written by secret.</p>
			<p>If you like it and want to support its development, stop by secret\'s <a href="https://liberapay.com/secret">Liberapay</a>, <a href="https://secret.fanbox.cc/">Fanbox</a>, or <a href="https://patreon.com/secret">Patreon</a>. You can also buy him <a href="https://ko-fi.com/secret">caffeine</a> or send <a href="https://secret.graphics/tipjar">a tip</a>.</p>
		</div>
		<p>( thanks } ( ´∀｀)</p>
	' . PAGE_FOOTER;
}
function render_endpoint_home() {
	# if the topmenu home uri is being used to link somewhere else then redirect to /search when trying to go to thalassa's built-in homepage
	if ('' != CONFIG['site_topmenu_home_uri']) {
		redirect('search');
	}
	return render_page_header('Home', 'home') . file_get_contents('custom/home.html') . PAGE_FOOTER;
}
function render_endpoint_help() {
	$res = render_page_header('Help', 'help') . '<h2>Help</h2>';
	$res .= file_get_contents('help.html');
	if (AUTHORIZED) {
		$res .= file_get_contents('operator_help.html');
	}
	return $res . PAGE_FOOTER;
}
function render_endpoint_set_first_pass() {
	# set first pass
	$res = render_page_header('Set initial pass', 'set-initial-pass') . '<h2>Set initial pass</h2>';
	if ('POST' == $_SERVER['REQUEST_METHOD']) {
		if (
			!array_key_exists('new_pass', $_POST) 
			|| !$_POST['new_pass'] 
			|| !array_key_exists('new_pass_confirmation', $_POST) 
			|| !$_POST['new_pass_confirmation']
		) {
			$res .= '<div class="error">You must enter and confirm a new pass</div>';
		}
		else {
			list($result_code, $result_output) = set_first_pass($_POST['new_pass'], $_POST['new_pass_confirmation']);
			if (0 == $result_code) {
				$token = $result_output[1];
				setcookie(
					CONFIG['cookie_name'],
					$token,
					time() + CONFIG['cookie_lifespan'],
					'/',
					CONFIG['cookie_domain'],
					CONFIG['cookie_secure'],
					true
				);
				redirect('search');
			}
			# errors
			$error = $result_output[0];
			if ('Pass already set' == $error) {
				redirect('search');
			}
			$res .= render_result_output_errors($result_output);
		}
	}
	return $res . FORM_FIRST_PASS . PAGE_FOOTER;
}
function render_endpoint_sign_in() {
	# sign in
	$res = render_page_header('Sign in', 'sign-in') . '<h2>Sign in</h2>';
	if ('POST' == $_SERVER['REQUEST_METHOD']) {
		list($result_code, $result_output) = check_pass($_POST['pass']);
		if (0 == $result_code) {
			$token = $result_output[1];
			setcookie(
				CONFIG['cookie_name'],
				$token,
				time() + CONFIG['cookie_lifespan'],
				'/',
				CONFIG['cookie_domain'],
				CONFIG['cookie_secure'],
				true
			);
			redirect('search');
		}
		# errors
		$res .= render_result_output_errors($result_output);
	}
	return $res . FORM_SIGN_IN . PAGE_FOOTER;
}
function render_endpoint_use_token() {
	$res = render_page_header('Use token', 'use-token') . '<h2>Use token</h2>';
	if ('POST' == $_SERVER['REQUEST_METHOD']) {
		if (
			!array_key_exists('token', $_POST) 
			|| '' == $_POST['token'] 
		) {
			$res .= '<div class="error">You must enter a token to use</div>';
		}
		setcookie(
			CONFIG['cookie_name'],
			$_POST['token'],
			time() + CONFIG['cookie_lifespan'],
			'/',
			CONFIG['cookie_domain'],
			CONFIG['cookie_secure'],
			true
		);
		redirect('search');
	}
	if (array_key_exists('token', QUERY_ARRAY)) {
		$token = QUERY_ARRAY['token'];
		setcookie(
			CONFIG['cookie_name'],
			$token,
			time() + CONFIG['cookie_lifespan'],
			'/',
			CONFIG['cookie_domain'],
			CONFIG['cookie_secure'],
			true
		);
		redirect('search');
	}
	return $res . FORM_USE_TOKEN . PAGE_FOOTER;
}
function render_endpoint_page() {
	if (array_key_exists('html_name', QUERY_ARRAY)) {
		$html_name = str_replace('.', '', QUERY_ARRAY['html_name']);
		if (file_exists('custom/' . $html_name . '.html')) {
			$html_contents = file_get_contents('custom/' . $html_name . '.html');
			#TODO get html title from html contents
			$html_title = $html_name;
			return render_page_header($html_title, $html_name) . $html_contents . PAGE_FOOTER;
		}
	}
	send_min_response(render_page_header('404 not found', 'missing-file') . '<h1>404 not found<h1>' . PAGE_FOOTER, 404);
}

function render_endpoint_store() {
	$res = render_page_header('Store files', 'store-files') . '<h2>Store files</h2>' . FORM_STORE_FILES;

	if ('POST' == $_SERVER['REQUEST_METHOD']) {
		initialize_post_keys(['datetime', 'tags', 'comma_separated_tags', 'tag_filenames', 'title', 'description']);
		$filenames = [];
		$temp_file_paths = [];
		# file upload
		if (
			array_key_exists('file_upload', $_FILES)
			&& 0 < count($_FILES['file_upload']['name'])
			&& !empty($_FILES['file_upload']['name'][0])
		) {
			list($new_temp_file_paths, $problem_upload_files, $new_filenames) = preprocess_uploaded_files($_FILES['file_upload']);
			$filenames = array_merge($filenames, $new_filenames);
			$temp_file_paths = array_merge($temp_file_paths, $new_temp_file_paths);
			foreach ($problem_upload_files as $problem_upload_file) {
				$filename = $problem_upload_file[0];
				$error = $problem_upload_file[1];
				$res .= '<div class="error">Problem moving uploaded temp file "' . $filename . '" (' . $error . ')</div>';
			}
		}
		# file fetch
		if (array_key_exists('file_fetch', $_POST)) {
			list($new_temp_file_paths, $problem_fetch_files, $new_filenames) = preprocess_fetched_files([$_POST['file_fetch']]);
			$filenames = array_merge($filenames, $new_filenames);
			$temp_file_paths = array_merge($temp_file_paths, $new_temp_file_paths);
			foreach ($problem_fetch_files as $file_url) {
				$res .= '<div class="error">Problem fetching file "' . $file_url . '"</div>';
			}
		}

		if (!empty($temp_file_paths)) {
			list($result_code, $result_output) = process_temp_files(
				$temp_file_paths,
				$_POST['datetime'],
				$_POST['tags'],
				$_POST['comma_separated_tags'],
				$_POST['tag_filenames'],
				$filenames,
				$_POST['title'],
				$_POST['description']
			);

			$possible_store_file_errors = [
				'Problem moving file to destination' => 'problem-moving-file',
				'File already exists' => 'file-already-exists',
				'Thumbnail not created' => 'thumbnail-not-created',
				'Thumbnail video clip not created' => 'thumbnail-video-clip-not-created',
			];

			$file_records = json_decode($result_output[0], true);
			if (!is_array($file_records)) {
				$res .= '<div class="stored-file"><div class="file-store-error problem-storing-any-files">Problem storing any files</div></div>';
			}
			else {
				foreach ($file_records as $file_record) {
					#$file_record = $file_records[$file_id];
					$thumbnail = render_thumbnail($file_record);
					$res .= '<div class="stored-file">';
					if (array_key_exists('errors', $file_record)) {
						foreach ($file_record['errors'] as $error) {
							if (array_key_exists($error, $possible_store_file_errors)) {
								$res .= '<div class="file-store-error ' . $possible_store_file_errors[$error] . '">' . $error . '</div>';
							}
						}
					}
					$res .= $thumbnail . '</div>';
				}
			}
		}
	}
	return $res . PAGE_FOOTER;
}

function render_endpoint_admin() {
	return render_page_header('Admin', 'admin') . '
		<h2>Admin index</h2>
		<div>
			<ul>
				<li><a href="' . THALASSA_URI . 'tags">Manage tags</a></li>
				<li><a href="' . THALASSA_URI . 'change_pass">Change pass</a></li>
				<li><a href="' . THALASSA_URI . 'tokens">Manage tokens</li>
				<li><a href="' . THALASSA_URI . 'config">Configuration</li>
				<li><a href="' . THALASSA_URI . 'storage">Storage info</li>
				<!-- li><a href="' . THALASSA_URI . 'initialize_database">Initialize database</a></li -->
				<li><a href="' . THALASSA_URI . 'rebuild_all">Rebuild all files</a></li>
			</ul>
		</div>' . PAGE_FOOTER;
}
function render_endpoint_tags() {
	$res = render_page_header('Manage tags', 'manage-tags') . '<h2>Manage tags</h2>';
	if (array_key_exists('generate', QUERY_ARRAY)) {
		generate_tag_suggestions();
		#TODO success page instead of transparent return to tags management?
		redirect('tags');
	}
	elseif (array_key_exists('remove', QUERY_ARRAY)) {
		if (array_key_exists('confirm', QUERY_ARRAY)) {
			remove_tags(QUERY_ARRAY['remove']);
			#TODO success page instead of transparent return to tags management?
			redirect('tags');
		}
		return $res . '
			<p>Really remove tag ' . render_tag(QUERY_ARRAY['remove']) . ' from all files?</p>
			<p>this can\'t be undone</p>
			<div>
				<a href="' . THALASSA_URI . 'tags?remove=' . urlencode(QUERY_ARRAY['remove']) . '&confirm=1"><input type="button" value="Remove"/></a>
			</div>' . PAGE_FOOTER;
	}
	elseif (array_key_exists('replace', QUERY_ARRAY)) {
		if ('POST' == $_SERVER['REQUEST_METHOD']) {
			$result = replace_tag(QUERY_ARRAY['replace'], $_POST['replacement']);
			#TODO success page instead of transparent return to tags management?
			redirect('tags');
		}
		return $res . '
			<p>Replace tag ' . render_tag(QUERY_ARRAY['replace']) . '</p>
			<form method="POST">
				<label for="replacement">Replacement</label> 
				<input id="replacement" name="replacement" type="text"/>
				<br/>
				<input type="submit" value="Replace"/>
			</form>' . PAGE_FOOTER;
	}
	#TODO remove false when accompany_tag is finished in thalassa.py
	elseif (array_key_exists('accompany', QUERY_ARRAY) && false) {
		if ('POST' == $_SERVER['REQUEST_METHOD']) {
			accompany_tag(QUERY_ARRAY['accompany'], $_POST['accompaniment']);
			#TODO success page instead of transparent return to tags management?
			redirect('tags');
		}
		return $res . '
			<p>Accompany tag ' . render_tag(QUERY_ARRAY['accompany']) . '</p>
			<form method="POST">
				<label for="accompaniment">Accompaniment</label> 
				<input id="accompaniment" name="accompaniment" type="text"/>
				<br/>
				<input type="submit" value="Accompany"/>
			</form>' . PAGE_FOOTER;
	}

	$tags = list_tags();

	# move audit tags to the top of the list
	$audit_tags = [];
	foreach ($tags as $k => $line) {
		list($tag, $count) = $line;
		if ('audit:' == substr($tag, 0, 6)) {
			array_push($audit_tags, $line);
			unset($tags[$k]);
		}
	}
	$tags = array_merge($audit_tags, $tags);

	#TODO uncomment accompany table column header when accompany_tag is finished in thalassa.py
	$res = render_page_header('Manage tags', 'manage-tags') . '
			<h2>Manage tags</h2>
			<nav>
				<a href="' . THALASSA_URI . 'tags?generate">Generate tag suggestions</a>
			</nav>
			<table border="1">
				<caption>' . count($tags) . ' total tags</caption>
				<thead>
					<tr>
						<th>Tag</th>
						<th>Count</th>
						<th>Remove</th>
						<th>Replace</th>
						<!-- th>Accompany</th -->
					</tr>
				</thead>
				<tbody>';

	foreach ($tags as $line) {
		list($tag, $count) = $line;
		#TODO uncomment accompany link when accompany_tag is finished in thalassa.py
		$res .= '
					<tr>
						<td>' . render_tag($tag) . '</td>
						<td>' . $count . '</td>
						<td><a href="' . THALASSA_URI . 'tags?remove=' . str_replace('"', '&quot;', $tag) . '">Remove</a></td>
						<td><a href="' . THALASSA_URI . 'tags?replace=' . str_replace('"', '&quot;', $tag) . '">Replace</a></td>
						<!-- td><a href="' . THALASSA_URI . 'tags?accompany=' . str_replace('"', '&quot;', $tag) . '">Accompany</a></td -->
					</tr>';
	}
	return $res . '
				</tbody>
			</table>' . PAGE_FOOTER;
}
function render_endpoint_change_pass() {
	$res = render_page_header('Change pass', 'change-pass') . '<h2>Change pass</h2>';
	if ('POST' == $_SERVER['REQUEST_METHOD']) {
		initialize_post_keys(['current_pass', 'new_pass', 'new_pass_confirmation']);
		list($result_code, $result_output) = change_pass($_POST['current_pass'], $_POST['new_pass'], $_POST['new_pass_confirmation']);
		if (0 == $result_code) {
			send_response($res . '<div>Successfully changed pass</div>' . PAGE_FOOTER);
		}
		$res .= render_result_output_errors($result_output);
	}
	return $res . FORM_CHANGE_PASS . PAGE_FOOTER;
}
function render_endpoint_tokens() {
	# generate token
	if (array_key_exists('generate', QUERY_ARRAY)) {
		write_new_token();
		redirect('tokens');
	}

	# manager use specific token
	if (array_key_exists('use', QUERY_ARRAY)) {
		$token = QUERY_ARRAY['use'];
		setcookie(
			CONFIG['cookie_name'],
			$token,
			time() + CONFIG['cookie_lifespan'],
			'/',
			CONFIG['cookie_domain'],
			CONFIG['cookie_secure'],
			true
		);
		redirect('tokens');
	}

	# remove token
	if (array_key_exists('remove', QUERY_ARRAY)) {
		if ('' != QUERY_ARRAY['remove']) {
			remove_tokens(QUERY_ARRAY['remove']);
		}
		redirect('tokens');
	}

	$tokens = list_tokens();

	# set token mode
	if (array_key_exists('set_mode', QUERY_ARRAY)) {
		$token = QUERY_ARRAY['set_mode'];
		if (!array_key_exists($token, $tokens)) {
			redirect('tokens');
		}
		# default token mode is viewer
		$token_mode = 'viewer';
		if (array_key_exists('token_mode', QUERY_ARRAY)) {
			if (in_array(QUERY_ARRAY['token_mode'], ['admin', 'helper', 'viewer'])) {
				$token_mode = QUERY_ARRAY['token_mode'];
			}
		}
		set_tokens_mode($token, $token_mode);
		redirect('tokens');
	}

	# change token nickname
	if (array_key_exists('name', QUERY_ARRAY)) {
		$token = QUERY_ARRAY['name'];
		if (!array_key_exists($token, $tokens)) {
			redirect('tokens');
		}
		$res = '';
		if ('POST' == $_SERVER['REQUEST_METHOD']) {
			$result = [-1, ['Unknown error']];
			if (array_key_exists('token_name', $_POST)) {
				$name_string = '';
				if ('' != $_POST['token_name']) {
					$name_string = $_POST['token_name'];
				}
				$result = set_token_name($token, $name_string);
			}
			list($result_code, $result_output) = $result;
			if (0 == $result_code) {
				redirect('tokens');
			}
			$res .= render_result_output_errors($result_output);
		}
		return render_page_header('Token nickname', 'token-nickname') . '
			<h2>Token nickname</h2>
			<p><code>' . $token . '</code></p>' . $res . '<form method="post">
				<label for="token-name">Name</label>
				<input id="token-name" name="token_name" type="text" value="' . str_replace('"', '&quot;', $tokens[$token]['name']) . '"/>
				<br/>
				<input type="submit" value="Change"/>
			</form>' . PAGE_FOOTER;
	}

	$token_rows = '';
	foreach ($tokens as $token=>$token_content) {
		$name_column = 'Anonymous';
		if ($token_content['name']) {
			$name_column = str_replace('<', '&lt;', $token_content['name']);
		}
		$mode_column = '';
		foreach (['admin', 'helper', 'viewer'] as $mode) {
			if ($mode == $token_content['mode']) {
				$mode_column .= '<strong>' . $mode . '</strong> ';
			}
			else {
				$mode_column .= '<a href="' . THALASSA_URI . 'tokens/set_mode/' . $token . '?token_mode=' . $mode . '">' . $mode . '</a><br/>';
			}
		}
		$use_column = '';
		if ($token == CURRENT_TOKEN) {
			$use_column = '<strong>Current</strong>';
		}
		else {
			$use_column = '<a href="' . THALASSA_URI . 'tokens/use/' . $token . '">Use</a>';
		}
		$share_column = '<a href="' . THALASSA_URI . 'use_token?token=' . $token . '">Share</a>';
		$token_rows .= '
				<tr>
					<td>
						<code>' . $token . '</code>
						<br/>
						<a href="' . THALASSA_URI . 'tokens/name/' . $token . '" title="Edit name">' . $name_column . '</a>
					</td>
					<td>' . $mode_column . '</td>
					<td>' . $use_column . '</td>
					<td>' . $share_column . '</td>
					<td><a href="' . THALASSA_URI . 'tokens/remove/' . $token . '">Remove</a></td>
				</tr>';
	}

	return render_page_header('Manage tokens', 'manage-tokens') . '
			<h2>Manage tokens</h2>
			<nav><a href="' . THALASSA_URI . 'tokens/generate">Generate token</a> <a href="' . THALASSA_URI . 'use_token">Token sign in</a></nav>
			<p>Tokens are the method used to identify yourself to the site</p>
			<p>A token can be set to one of three different modes</p>
			<table>
				<tr>
					<td>admin</td>
					<td>Access all the regular site functions (e.g. adding, removing, and editing files and tags), as well as all the administrative functions; including changing the basic site configuration, seeing/changing the mode of/using/removing existing tokens, and generating new tokens. <small>(Note that changing the primary pass requires entering the current pass)</small></td>
				</tr>
				<tr>
					<td>helper</td>
					<td>View search results for all files and add tags. <small>(if mistakes are made or found by helpers they should add a tag such as <span class="tag" data-tag="audit:"><a>#audit:{reason}</a></span> for an admin to review and remove or change the necessary tags)</small></td>
				</tr>
				<tr>
					<td>viewer</td>
					<td>View search results for files tagged with <span class="tag" data-tag="protected"><a>#protected</a></span>, which normally are hidden.</td>
				</tr>
			</table>
			<p>Tokens are primarily intended to separate actions of multiple devices or trusted users, but are not a guaranteed way to tell which user performed which action if multiple users gain access to the same token</p>
			<p>An admin token should only be given to someone you trust to help manage the site.</p>
			<table border="1">
				<thead>
					<tr>
						<th>Token</td>
						<th>Mode</td>
						<th>Use</td>
						<th>Share</td>
						<th>Remove</td>
					</tr>
				</thead>
				<tbody>' . $token_rows . '
				</tbody>
			</table>' . PAGE_FOOTER;
}
function render_endpoint_config() {
	$editable_config_keys = [
		'site_name' => 'the name of your website',
		'site_title' => 'the title of your website',
		'site_image_uri' => 'image to use for default social embeds',
		'site_color' => 'accent color to use for social embeds',
		'site_theme' => 'default theme',
		'site_favicon_ico_uri' => 'file to use for the favicon.ico',
		'site_favicon_png_uri' => 'file to use for favicon.png',
		'site_language' => 'site language code',
		'site_topmenu_home_uri' => 'home link target (blank for thalassa home)',
		'site_topmenu_search_text' => 'search link text',
		'site_topmenu_store_files_text' => 'store files link text',
		'default_filtered_tags' => 'default filtered tags (# separated)',
		'admin_name' => 'usually your name or handle',
		'default_publish_time_new_files' => 'default publish time for new files',
		'default_tags_new_files' => 'default tags for new files (# separated)',
	];
	if ('POST' == $_SERVER['REQUEST_METHOD']) {
		# get thalassa_site_config.json directly
		$thalassa_site_config = json_decode(file_get_contents('thalassa_site_config.json'), true);
		# replace config values with the values submitted
		foreach ($editable_config_keys as $key => $description) {
			if (array_key_exists('config_' . $key, $_POST)) {
				$thalassa_site_config[$key] = str_replace('"', '&quot;', $_POST['config_' . $key]);
			}
		}
		# write thalassa_site_config.json back and redirect
		file_put_contents('thalassa_site_config.json', json_encode($thalassa_site_config, JSON_PRETTY_PRINT));
		redirect('config');
	}
	$res = '
		<form method="post">';
	foreach ($editable_config_keys as $key => $description) {
		$description = str_replace('"', '&quot;', $description);
		$res .= '
			<label for="config-' . $key . '" title="' . $description . '">' . $key . '</label> <input id="config-' . $key . '" name="config_' . $key . '" type="text" value="' . str_replace('"', '&quot;', CONFIG[$key]) . '" placeholder="' . $description . '"/>
			<br/>';
	}
	$res .= '
			<input type="submit"/>
		</form>
		<p>Advanced configuration options can be changed by editing thalassa_site_config.json directly</p>
		<script type="text/javascript" src="static/script/config.js"></script>';
	return render_page_header('Configuration', 'config') . '<h2>Configuration</h2>' . $res . PAGE_FOOTER;
}
function render_endpoint_storage() {
	$res = '
		<table border="1">
			<thead>
				<tr>
					<th>Path</th>
					<th>Files</th>
					<th>Size</th>
				</tr>
			</thead>
			<tbody>';
	$sizes = [];
	foreach (['original', 'summary', 'thumbnail', 'temp'] as $directory) {
		$bytestotal = 0;
		$path = THALASSA_INFO['config_files_directory_path'] . $directory;
		$path = realpath($path);
		$i = 0;
		if ($path !== false && $path != '' && file_exists($path)) {
			foreach (new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path, FilesystemIterator::SKIP_DOTS)) as $object) {
				$i++;
				$bytestotal += $object->getSize();
			}
		}
		$res .= '
				<tr>
					<td>' . $directory . '</td>
					<td>' . $i . '</td>
					<td>' . render_file_size($bytestotal) . '</td>
				</tr>';
	}
	$res .= '
				<tr>
					<td>database</td>
					<td>1</td>
					<td>' . render_file_size(filesize(THALASSA_INFO['config_database_file_path'])) . '</td>
				</tr>
			</tbody>
		</table>';
	return render_page_header('Storage info', 'storage') . '<h2>Storage info</h2>' . $res . PAGE_FOOTER;
}
function render_endpoint_initialize_database() {
	list($result_code, $result_output) = initialize_database();

	$res = '';
	if (0 == $result_code) {
		$res .= '<div>Successfully initialized database</div>';
	}
	else {
		$res .= '<div class="error">' . $result_output . '</div>';
	}
	return render_page_header('Initialize database', 'initialize-database') . '<h2>Initialize database</h2>' . $res . PAGE_FOOTER;
}
function render_endpoint_rebuild_all() {
	if (array_key_exists('confirm', QUERY_ARRAY)) {
		list($result_code, $result_output) = rebuild_all();
		$res = '';
		if (0 == $result_code) {
			$res .= '<h3>Success</h3><pre style="text-align:left;">';
			foreach ($result_output as $k=>$v) {
				$res .= $v . '<br/>';
			}
			$res .= '</pre>';
		}
		else {
			foreach ($result_output as $k=>$v) {
				$res .= '<div class="error">' . $v . '</div>';
			}
		}
	}
	else {
		$res = '
			<p>Really rebuild all files?</p>
			<p>This may take a very long time depending on the number of files in the archive, their sizes, and the processing power of the server</p>
			<p>A shared hosting provider that limits resource usage may also stop the execution prematurely</p>
			<div>
				<a href="' . THALASSA_URI . 'rebuild_all?confirm=1"><input type="button" value="Begin rebuilding"/></a>
			</div>';
	}

	return render_page_header('Rebuild all files', 'rebuild-all') . '<h2>Rebuild all files</h2>' . $res . PAGE_FOOTER;
}

function render_endpoint_search() {
	$res = render_page_header('Search files', 'search-files');

	$query_tags_string = '';
	# exposing tags
	if (EXPOSE_TAGS) {
		# searching some tags
		if (array_key_exists('tags', QUERY_ARRAY)) {
			$query_tags_string = QUERY_ARRAY['tags'];
			$query_tags_string = format_tags_string($query_tags_string);
		}
		$res .= '
			<form action="' . THALASSA_URI . 'search" method="GET">
				<input id="tags" name="tags" type="text" value="' . str_replace('"', '&quot;', $query_tags_string) . '" data-max-tags="12" data-too-many-tags="Maximum allowed search tags"/> 
				<input type="submit" value="Search"/>
			</form>';
	}

	$page = '0';
	if (array_key_exists('page', QUERY_ARRAY) && 0 < (int)QUERY_ARRAY['page']) {
		$page = QUERY_ARRAY['page'];
	}

	$exclude_future = false;
	$search_files_management_script = '';
	# duplicating tags query string so it can be modified in the case of non-authorized
	$search_tags_string = $query_tags_string;
	$exclude_future = true;
	if (!AUTHORIZED) {
		# always exclude future and omit hidden from searches while not authorized
		$search_tags_string .= '#-hidden#-protected';
	}
	# still omit hidden from searches for viewers
	elseif (TOKEN_MODE == 'viewer') {
		$search_tags_string .= '#-hidden';
	}
	# admin and helper get search files management and postdated files
	elseif (in_array(TOKEN_MODE, ['admin', 'helper'])) {
		$exclude_future = false;
		$res .= '<link rel="stylesheet" type="text/css" href="' . STATIC_URI . 'style/files_management.css"/>';
		$search_files_management_script = '<script type="module" src="' . STATIC_URI . 'script/files_management.js"></script>';
	}

	list($result_code, $result_output) = search_files($search_tags_string, $page, $exclude_future);
	$search_files_result = parse_search_files_output($result_output);

	# no search results returns early with just help link in navigation
	if (0 == $search_files_result['total_results']) {
		return $res . '<nav id="search-files-navigation"><a href="' . THALASSA_URI . 'help">Help</a></nav><script type="module" src="' . STATIC_URI . 'script/search_files.js"></script>' . PAGE_FOOTER;
	}

	# search results info and navigation
	if (!is_numeric($search_files_result['total_results'])) {
		$search_files_result['total_results'] = -1;
	}
	$res .= '
		<nav id="search-files-navigation">
			<span>' . number_format($search_files_result['total_results']) . ' files</span> 
			<span>' . render_file_size($search_files_result['total_size']) . '</span> 
			<a href="' . THALASSA_URI . 'help">Help</a> 
			<a href="' . THALASSA_URI . 'feed';
	if ('' != $query_tags_string) {
		$res .= '?tags=' . urlencode($query_tags_string);
	}
	$res .= '">Feed</a>
		</nav>';

	# rendering thumbnails and gathering page tags
	$page_tags = [];
	$thumbnails = '';
	$i = 0;
	while ($i < $search_files_result['results_this_page']) {
		$file_id = array_shift($search_files_result['file_ids']);
		$file_record = $search_files_result['file_records'][$file_id];
		foreach ($file_record['tags'] as $tag) {
			array_push($page_tags, trim($tag));
		}
		$thumbnails .= render_thumbnail($file_record, $search_files_result['file_records']);
		$i++;
	}

	# tags this page
	if ($page_tags && EXPOSE_TAGS) {
		$query_tags = [];
		if ('' != $query_tags_string) {
			$query_tags = explode('#', $query_tags_string);
		}
		$res .= '<div id="tags-this-page"><h2>Tags this page</h2>';
		$page_tags = declutter_tags(array_unique($page_tags, SORT_STRING));
		sort($page_tags);
		foreach ($page_tags as $page_tag) {
			# fresh current query tags string for each tag in tags this page
			$current_query_tags_string = '?tags=';
			foreach ($query_tags as $query_tag) {
				$query_tag = trim($query_tag);
				# build current query tags string from all query tags except the current page tag
				if ('' != $query_tag && $query_tag != $page_tag) {
					$current_query_tags_string .= urlencode('#' . $query_tag);
				}
			}
			$quotesafe_page_tag = str_replace('"', '&quot;', trim($page_tag));
			# patch in the add and remove buttons at the end of the rendered tag
			$add_remove_buttons = '</a>
					<a 
						class="action add" 
						href="' . THALASSA_URI . 'search' . $current_query_tags_string . urlencode('#' . $page_tag) . '" 
						title="Add this tag to the current search">+</a> 
					<a 
						class="action remove" 
						href="' . THALASSA_URI . 'search' . $current_query_tags_string . urlencode('#-' . $page_tag) . '" 
						title="Remove this tag from the current search">-</a>
				</span>';
			$res .= str_replace('</a></span>', $add_remove_buttons, render_tag($page_tag));
		}
		$res .= '</div>';
	}

	# thumbnails
	$res .= '<div id="results">' . $thumbnails . '</div>';

	# pages navigation
	if (1 < $search_files_result['total_pages']) {
		$res .= '<nav class="pages">';
		$pagenum = (int)$page;
		$page_tags_query = '';
		if ('' != $query_tags_string) {
			$page_tags_query = '?tags=' . urlencode($query_tags_string);
		}
		if ($pagenum > 0) {
			$res .= '<a href="' . THALASSA_URI . 'search/' . ($pagenum - 1) . $page_tags_query . '" id="prev-page">Prev</a> ';
		}
		$start_page = $pagenum - 3;
		if (0 > $start_page) {
			$start_page = 0;
		}
		$end_page = $pagenum + 3;
		if ($search_files_result['total_pages'] < $end_page) {
			$end_page = $search_files_result['total_pages'];
		}

		if (0 != $start_page) {
			$res .= '<a href="' . THALASSA_URI . 'search/0' . $page_tags_query . '" class="page">0</a> ';
			if (1 < $start_page) {
				$res .= '<strong class="page">...</strong> ';
			}
		}
		for ($i = $start_page; $i < $end_page; $i++) {
			if ($i == $pagenum) {
				$res .= '<strong class="page">' . $i . '</strong> ';
			}
			else {
				$res .= '<a href="' . THALASSA_URI . 'search/' . $i . $page_tags_query . '" class="page">' . $i . '</a> ';
			}
		}
		if ($search_files_result['total_pages'] != $end_page) {
			if ($search_files_result['total_pages'] - 1 > $end_page) {
				$res .= '<strong class="page">...</strong> ';
			}
			$res .= '<a href="' . THALASSA_URI . 'search/' . ($search_files_result['total_pages'] - 1) . $page_tags_query . '" class="page">' . ($search_files_result['total_pages'] - 1) . '</a> ';
		}
		if ($pagenum < $search_files_result['total_pages'] - 1) {
			$res .= '<a href="' . THALASSA_URI . 'search/' . ($pagenum + 1) . $page_tags_query . '" id="next-page">Next</a>';
		}
		$res .= '</nav>';
	}

	return $res . '
		<script type="module" src="' . STATIC_URI . 'script/search_files.js"></script>
		<script type="text/javascript" src="' . STATIC_URI . 'script/filtered_tags.js"></script>' . $search_files_management_script . PAGE_FOOTER;
}
function render_endpoint_feed() {
	$language = CONFIG['site_language'];
	$title = CONFIG['site_name'];
	$subtitle = CONFIG['site_title'] . ' - Atom feed';
	$author_name = CONFIG['admin_name'];
	$category = CONFIG['feed_category'];
	$rights = '(c) ' . CONFIG['admin_name'];
	$icon = CONFIG['site_favicon_png_uri'];
	$logo = CONFIG['site_image_uri'];
	$link_self = THALASSA_URI . 'feed';
	$link_alternate = THALASSA_URI . 'search';

	$query_tags_string = '';
	# exposing and searching some tags
	if (EXPOSE_TAGS && array_key_exists('tags', QUERY_ARRAY)) {
		$query_tags_string = QUERY_ARRAY['tags'];
		$query_tags_string = format_tags_string($query_tags_string);
		$subtitle .= ' - ' . $query_tags_string;
		$link_self .= urlencode('?tags=' . $query_tags_string);
		$link_alternate .= urlencode('?tags=' . $query_tags_string);
	}

	$exclude_future = true;
	# duplicating tags query string so it can be modified in the case of non-authorized
	$search_tags_string = $query_tags_string;

	if (!AUTHORIZED) {
		# always exclude future and omit hidden from searches while not authorized
		$search_tags_string .= '#-hidden#-protected';
	}
	# still omit hidden from searches for viewers
	elseif (TOKEN_MODE == 'viewer') {
		$search_tags_string .= '#-hidden';
	}
	# admin and helper get search files management and postdated files
	elseif (in_array(TOKEN_MODE, ['admin', 'helper'])) {
		$exclude_future = false;
	}

	# limit perpage to CONFIG['feed_entries']
	$search_tags_string .= '#perpage:' . CONFIG['feed_entries'];

	list($result_code, $result_output) = search_files($search_tags_string, 0, $exclude_future);
	$search_files_result = parse_search_files_output($result_output);

	$updated_atom_datetime = render_atom_time(time());
	if (0 < $search_files_result['total_results']) {
		$first_file_record = $search_files_result['file_records'][$search_files_result['file_ids'][0]];
		$updated_atom_datetime = render_atom_time($first_file_record['upload_time']);
	}

	header('Content-Type: application/xml');
	$res = '<?xml version="1.0" encoding="utf-8"?>
<?xml-stylesheet type="text/xsl" href="' . STATIC_URI . 'style/thalassa.xsl"?>
<feed xmlns="http://www.w3.org/2005/Atom" xml:lang="' . $language . '">
	<title type="text">' . $title . '</title>
	<subtitle type="text"><![CDATA[ ' . $subtitle . ' ]]></subtitle>
	<link href="' . $link_self . '" rel="self" type="application/atom+xml"/>
	<link href="' . $link_alternate . '" rel="alternate" type="text/html"/>
	<updated>' . $updated_atom_datetime . '</updated>
	<id>' . $link_self . '</id>
	<author>
		<name>' . $author_name . '</name>
	</author>
	<category term="' . $category . '"/>
	<rights type="text">' . $rights . '</rights>
	<icon>' . $icon . '</icon>
	<logo>' . $logo . '</logo>
	<generator 
		uri="https://secret.graphics/projects/thalassa/"
		version="' . THALASSA_INFO['thalassa_version'] . '">
		thalassa
	</generator>';

	$i = 0;
	while ($i < $search_files_result['results_this_page']) {
		$file_id = array_shift($search_files_result['file_ids']);
		$file_record = $search_files_result['file_records'][$file_id];
		$title = 'No title';#$file_record['file_id'];
		# summary
		$summary = $file_record['category'] . ' ' . render_file_size($file_record['size']);
		if (0 < $file_record['width'] && 0 < $file_record['height']) {
			$summary .= ', ' . $file_record['width'] . 'x' . $file_record['height'];
		}
		if (0 < $file_record['duration']) {
			$summary .= ', ' . $file_record['duration'];
			if ('image/gif' == $file_record['mimetype']) {
				$summary .= ' frames';
			}
			else {
				$summary .= ' seconds';
			}
		}
		if ('text' == $file_record['category']) {
			#TODO sanitize for atom xml
#			$summary .= ' | ' . file_get_contents(THALASSA_INFO['config_files_directory_path'] . 'original/' . $file_record['file_id'] . '.' . $file_record['extension'], FALSE, NULL, 0, CONFIG['text_opengraph_character_limit']);
		}

		$id = THALASSA_URI . 'view/' . $file_record['file_id'];
		$file_author = '';
		$category = $file_record['category'];
		$tags_string = '';
		$description = '';
		foreach ($file_record['tags'] as $tag) {
			if ('title:' == substr($tag, 0, 6)) {
				$title = substr($tag, 6);
			}
			if ('description:file:' == substr($tag, 0, 17)) {
				$description_file_id = substr($tag, 17);

				#TODO eventually thalassa core will include description:file:[file_id] records in search results
				#$description_file_record = $search_files_result['file_records'][$description_file_id];

				#TODO but for now we have to do another search query to get them
				list($description_result_code, $description_result_output) = search_files('#id:' . $description_file_id);
				$description_search_files_result = parse_search_files_output($description_result_output);
				# specified file record was in results
				if (array_key_exists($description_file_id, $description_search_files_result['file_records'])) {
					$description_file_record = $description_search_files_result['file_records'][$description_file_id];
					$description = file_get_contents(THALASSA_INFO['config_files_directory_path'] . 'original/' . $description_file_record['file_id'] . '.' . $description_file_record['extension']);
					if (in_array('text:html fragment', $description_file_record['tags'])) {
						$summary = '<![CDATA[ ' . $description . '<br/>' . $summary . ' ]]>';
					}
					else {
						$summary = $description . ' - ' . $summary;
					}
				}
			}
			elseif ('description:' == substr($tag, 0, 12)) {
				$description = substr($tag, 12);
				if ('html:' == substr($description, 0, 5)) {
					$description = substr($description, 5);
					$summary = '<![CDATA[ ' . $description . '<br/>' . $summary . ' ]]>';
				}
				else {
					$summary = $description . ' - ' . $summary;
				}
			}
			if ('author:' == substr($tag, 0, 7)) {
				$author = substr($tag, 7) . ', ';
			}
		}
		# author was tagged
		if ('' != $file_author) {
			# strip leading comma space
			$file_author = substr($file_author, 0, -2);
		}

		$feed_content = '<div class="feed">' . render_thumbnail($file_record, $search_files_result['file_records'], true) . '</div>';
		$feed_content .= '<link rel="stylesheet" href="' . STATIC_URI . 'style/files.css" />';
		#TODO include javascript to preview hover animated gifs and videos

		$res .= '
	<entry>
		<title type="text">' . $title . '</title>
		<summary type="text">' . $summary . '</summary>
		<link href="' . THALASSA_URI . 'view/' . $file_record['file_id'] . '" rel="alternate" type="text/html"/>
		<published>' . render_atom_time($file_record['publish_time']) . '</published>
		<updated>' . render_atom_time($file_record['publish_time']) . '</updated>
		<id>' . $id . '</id>
		<content xml:lang="en" type="html"><![CDATA[ ' . $feed_content . ' ]]></content>
		<author><name>' . $file_author . '</name></author>
		<category term="' . $category . '"/>
	</entry>';
		$i++;
	}
	$res .= '
</feed>';
	return $res;
}
function render_endpoint_view() {
	$file_id = QUERY_ARRAY['file_id'];

	list($result_code, $result_output) = search_files('#id:' . $file_id);

	$search_files_result = parse_search_files_output($result_output);
	$file_records = $search_files_result['file_records'];

	if (0 == count($search_files_result['file_ids'])) {
		send_min_response(render_page_header('404 not found', 'missing-file') . '<h1>404 not found<h1>' . PAGE_FOOTER, 404);
	}
	$file_record = $file_records[$search_files_result['file_ids'][0]];

	$file_title = '';
	if ($file_record['tags']) {
		foreach ($file_record['tags'] as $tag) {
			if ('title:' == substr($tag, 0, 6)) {
				$file_title = substr($tag, 6);
			}
		}
	}
	if ('' == $file_title) {
		$file_title = $file_record['file_id'];
	}

	$opengraph = [];
	if ('video' == $file_record['category']) {
		$video = FILES_URI . 'original/' . $file_record['file_id'] . '.' . $file_record['extension'];
		$opengraph['property="og:video"'] = $video;
		$opengraph['property="og:video:type"'] = $file_record['mimetype'];
		$opengraph['property="og:type"'] = 'video.other';
	}
	if ('audio' == $file_record['category']) {
		$audio = FILES_URI . 'original/' . $file_record['file_id'] . '.' . $file_record['extension'];
		$opengraph['property="og:audio"'] = $audio;
		$opengraph['property="og:audio:type"'] = $file_record['mimetype'];
	}

	$og_description = substr(render_atom_time($file_record['publish_time']), 0, 10);
	$og_author = '';
	$tags = '';
	if (EXPOSE_TAGS && !in_array('hide tags', $file_record['tags'])) {
		$decluttered_tags = declutter_tags($file_record['tags']);
		if (0 < count($decluttered_tags)) {
			$tags .= '
				<div class="tags">';
			foreach ($decluttered_tags as $tag) {
				if ('author:' == substr($tag, 0, 7)) {
					$og_author .= ', ' . substr($tag, 7);
				}
				elseif ('title:' != substr($tag, 0, 6)) {
					$og_description .= ' #' . $tag;
				}
				$tags .= render_tag($tag);
			}
			$tags .= '
				</div>';
		}
	}

	if ('text' == $file_record['category']) {
		$short_text = ' - ' . file_get_contents(THALASSA_INFO['config_files_directory_path'] . 'original/' . $file_record['file_id'] . '.' . $file_record['extension'], FALSE, NULL, 0, CONFIG['text_opengraph_character_limit']);
		$og_description .= $short_text;
	}

	$og_description = str_replace('"', '&quot;', $og_description);
	$og_description = str_replace('<', '&lt;', $og_description);
	$opengraph['property="og:description"'] = $og_description;
	$opengraph['name="twitter:description"'] = $og_description;

	if (', ' == substr($og_author, 0, 2)) {
		$og_author = substr($og_author, 2);
	}
	$og_author = str_replace('"', '&quot;', $og_author);
	$opengraph['property="og:author"'] = $og_author;

	# visual summary
	$visual_file_record = null;
	$viewing_resized = false;
	# cover file specified, and it existed in file_records, and it had a category of image or video
	if (
		$file_record['cover_file_id']
		&& array_key_exists($file_record['cover_file_id'], $search_files_result['file_records'])
		&& in_array($search_files_result['file_records'][$file_record['cover_file_id']]['category'], ['image', 'video'])
	) {
		# use cover file record for visual
		$visual_file_record = $search_files_result['file_records'][$file_record['cover_file_id']];
	}
	# actual file record had a category of image or video
	elseif (in_array($file_record['category'], ['image', 'video'])) {
		$visual_file_record = $file_record;
	}

	# category placeholder image
	$category_image = STATIC_URI . 'style/file_category_' . $file_record['category'];

	$placeholder = '';
	$image = '';
	$player = '';
	# getting inner and player from visual summary
	if ($visual_file_record) {
		# video
		if ('video' == $visual_file_record['category']) {
			#TODO leave out height to let the browser handle sizing the player
			# height="' . $file_record['height'] . '"
			$player = '
				<video 
					poster="' . FILES_URI . 'thumbnail/' . $visual_file_record['file_id'] . '.' . $file_record['thumbnail'] . '" 
					preload="auto" 
					controls="" 
					loop="" 
					width="' . $file_record['width'] . '">
					<source 
						src="' . FILES_URI . 'original/' . $file_record['file_id'] . '.' . $file_record['extension'] . '" 
						type="' . $file_record['mimetype'] . '">
					Video element not supported
				</video>';
		}
		# image
		elseif ('image' == $visual_file_record['category']) {
			# get summary
			$visual_file_dir = 'original';
			$visual_file_extension = $visual_file_record['extension'];
			if ($visual_file_record['summary']) {
				$viewing_resized = true;
				$visual_file_dir = 'summary';
				$visual_file_extension = $visual_file_record['summary'];
			}

			# card image for visual file records
			$og_image = FILES_URI . $visual_file_dir . '/' . $visual_file_record['file_id'] . '.' . $visual_file_extension;
			$opengraph['property="og:image"'] = $og_image;
			$opengraph['name="twitter:image"'] = $og_image;

			$image = '
				<picture>
					<source 
						srcset="' . FILES_URI . $visual_file_dir . '/' . $visual_file_record['file_id'] . '.' . $visual_file_extension . '" 
						type="' . $visual_file_record['mimetype'] . '"/>
					<img src="' . FILES_URI . $visual_file_dir . '/' . $visual_file_record['file_id'] . '.' . $visual_file_extension . '" alt=""/>
				</picture>';
		}
	}
	# no visual summary, but audio had native thumbnail
	elseif ('audio' == $file_record['category'] && $file_record['thumbnail']) {
		$image = '
				<picture>
					<source 
						srcset="' . FILES_URI . 'thumbnail/' . $file_record['file_id'] . '.' . $file_record['thumbnail'] . '" 
						type="';
		if ('jpg' == $file_record['thumbnail']) {
			$image .= 'image/jpeg';
		}
		elseif ('webp' == $file_record['thumbnail']) {
			$image .= 'image/webp';
		}
		$image .= '"
						/>
					<img src="' . FILES_URI . 'thumbnail/' . $file_record['file_id'] . '.' . $file_record['thumbnail'] . '" alt=""/>
				</picture>';
	}
	else {
		$placeholder = ' placeholder';
		$image = '
				<picture>
					<source 
						srcset="' . $category_image . '.svg" 
						type="image/svg"/>
					<img src="' . $category_image . '.svg" alt=""/>
				</picture>';
	}
	# wrap image in direct file link
	if ('' != $image) {
		$image = '<a href="' . FILES_URI . 'original/' . $file_record['file_id'] . '.' . $file_record['extension'] . '">' . $image . '</a>';
	}

	# rendered text and audio player
	$text = '';
	if ('text' == $file_record['category'] && in_array('text:plain', $file_record['tags'])) {
		$text = '<pre class="text">' . str_replace('<', '&lt;', file_get_contents(THALASSA_INFO['config_files_directory_path'] . 'original/' . $file_record['file_id'] . '.' . $file_record['extension'])) . '</pre>';
	}
	elseif ('text' == $file_record['category'] && in_array('text:html fragment', $file_record['tags'])) {
		$text = '<div class="html-fragment">' . file_get_contents(THALASSA_INFO['config_files_directory_path'] . 'original/' . $file_record['file_id'] . '.' . $file_record['extension']) . '</div>';
	}
	elseif ('audio' == $file_record['category']) {
		$player = '
				<audio controls="">
					<source src="' . FILES_URI . 'original/' . $file_record['file_id'] . '.' . $file_record['extension'] . '" type="' . $file_record['mimetype'] . '">
					Audio element not supported
				</audio>';
	}
	# ignore image if rendering text
	if ('' != $text) {
		$image = '';
	}

	# file info
	$file_info = '
			<div class="file-info">
				<a class="direct-link" href="' . FILES_URI . 'original/' . $file_record['file_id'] . '.' . $file_record['extension'] . '" title="' . $file_record['category'] . ' file">
					<picture>
						<source 
							srcset="' . $category_image . '.svg" 
							type="image/svg"/>
						<img src="' . $category_image . '.svg" alt=""/>
					</picture>
				</a>
				<span class="file-size">' . render_file_size($file_record['size']) . '</span> 
				<span class="time" data-timestamp="' . $file_record['publish_time'] . '" title="' . render_atom_time($file_record['publish_time']) . '">' . render_fuzzy_time($file_record['publish_time']) . '</span> ';
	# dimensions
	if (in_array($file_record['category'], ['image','video'])) {
		$file_info .= '
				<span class="dimensions">
					<span class="width">' . $file_record['width'] . '</span>x<span class="height">' . $file_record['height'] . '</span>
				</span> ';
	}
	# video duration
	if (in_array($file_record['category'], ['video', 'audio'])) {
		#TODO leaving out visible video and audio duration for now, because it's already displayed in the video and audio elements
		#$file_info .= '<span class="duration">' . render_duration($file_record['duration']) . '</span>';
	}
	# animated gif frames
	elseif ('image/gif' == $file_record['mimetype'] && $file_record['duration']) {
		$file_info .= '
				<span class="duration">' . $file_record['duration'] . ' frames</span>';
	}
	if ($viewing_resized) {
		$file_info .= '
				<span class="summarized">viewing resized</span>';
	}
	$file_info .= '
			</div>';

	# description
	$description = '';
	foreach ($file_record['tags'] as $tag) {
		if ('description:file:' == substr($tag, 0, 17)) {
			$description_file_id = substr($tag, 17);

			#TODO eventually thalassa core will include description:file:[file_id] records in search results
			#$description_file_record = $search_files_result['file_records'][$description_file_id];

			#TODO but for now we have to do another search query to get them
			list($description_result_code, $description_result_output) = search_files('#id:' . $description_file_id);
			$description_search_files_result = parse_search_files_output($description_result_output);
			# specified file record was in results
			if (array_key_exists($description_file_id, $description_search_files_result['file_records'])) {
				$description_file_record = $description_search_files_result['file_records'][$description_file_id];
				$description = file_get_contents(THALASSA_INFO['config_files_directory_path'] . 'original/' . $description_file_record['file_id'] . '.' . $description_file_record['extension']);
				# html description
				if (in_array('text:html fragment', $description_file_record['tags'])) {
					#
				}
				# plaintext description
				else {
					$description = str_replace('<', '&lt;', $description);
				}
				$description = '<div class="description">' . $description . '</div>';
			}
		}
		elseif ('description:' == substr($tag, 0, 12)) {
			$description = substr($tag, 12);
			# html description
			if ('html:' == substr($description, 0, 5)) {
				$description = substr($description, 5);
			}
			# plaintext description
			else {
				$description = str_replace('<', '&lt;', $description);
			}
			$description = '<div class="description">' . $description . '</div>';
		}
	}

	# sets
	if (array_key_exists('sets', $file_record) && 0 < count($file_record['sets'])) {
		$set_count = count($file_record['sets']);
		$sets_description = ', ' . $set_count . ' set' . (1 < $set_count ? 's' : '');
		$unique_additional_set_files = [];
		foreach ($file_record['sets'] as $set_file_ids) {
			foreach ($set_file_ids as $set_file_id) {
				if (!in_array($set_file_id, $unique_additional_set_files) && $set_file_id != $file_id) {
					array_push($unique_additional_set_files, $set_file_id);
				}
			}
		}
		$sets_description .= ' (' . count($unique_additional_set_files) . ' additional files)';
		$opengraph['property="og:description"'] .= $sets_description;
		$opengraph['name="twitter:description"'] .= $sets_description;
	}
	$sets = '';
	foreach ($file_record['sets'] as $file_ids) {
		$sets .= '<div class="set">';
		foreach ($file_ids as $file_id) {
			$set_file_record = $search_files_result['file_records'][$file_id];
			$thumbnail = render_thumbnail($set_file_record, $search_files_result['file_records']);
			if ($file_record['file_id'] == $set_file_record['file_id']) {
				$thumbnail = str_replace('class="thumbnail"', 'class="thumbnail current"', $thumbnail);
			}
			$sets .= $thumbnail;
		}
		$sets .= '</div>';
	}
	$res = render_page_header('View file "' . $file_title . '"', 'view-file', $opengraph);

	#TODO page header for title
	if (false && $file_title != $file_record['file_id']) {
		$res .= '<h2>' . $file_title . '</h2>';
	}

	if (in_array('hide file container', $file_record['tags'])) {
		$res .= $image . $player . $text;
	}
	else {
		$res .= '
			<div 
				class="file" 
				data-id="' . $file_record['file_id'] . '" 
				data-upload-time="' . $file_record['upload_time'] . '" 
				data-publish-time="' . $file_record['publish_time'] . '" 
				data-category="' . $file_record['category'] . '" 
				data-mimetype="' . $file_record['mimetype'] . '" 
				data-size="' . $file_record['size'] . '" 
				data-width="' . $file_record['width'] . '" 
				data-height="' . $file_record['height'] . '" 
				data-duration="' . $file_record['duration'] . '">
				<div 
					class="summary" 
					data-id="' . $file_record['file_id'] . '" 
					data-width="' . $file_record['width'] . '" 
					data-height="' . $file_record['height'] . '">
					<div class="inner' . $placeholder . '">
						' . $image . $player . $text . '
					</div>
				</div>' . $file_info . $tags . $description . '
			</div>
			' . $sets . '
			<script type="module" src="' . STATIC_URI . 'script/view_file.js"></script>
			<script type="text/javascript" src="' . STATIC_URI . 'script/filtered_tags.js"></script>';
	}

	if (AUTHORIZED && 'admin' == TOKEN_MODE) {
		# replace tags or set publish time
		if ('POST' == $_SERVER['REQUEST_METHOD']) {
			$result = [-1, ['Unknown error']];
			if (array_key_exists('tags', $_POST)) {
				$tags_string = '';
				if ('' != $_POST['tags']) {
					$tags_string = $_POST['tags'];
				}
				$comma_separated_tags = false;
				if (array_key_exists('comma_separated_tags', $_POST) && '' != $_POST['comma_separated_tags']) {
					$comma_separated_tags = true;
				}
				$result = edit_files_tags($file_record['file_id'], 'replace', $tags_string, $comma_separated_tags);
			}
			elseif (array_key_exists('datetime', $_POST)) {
				$result = set_publish_time($file_record['file_id'], $_POST['datetime']);
			}
			list($result_code, $result_output) = $result;
			if (0 == $result_code) {
				redirect('view/' . $file_record['file_id']);
			}
			$res .= render_result_output_errors($result_output);
		}

		# rebuild file supplemental
		if (array_key_exists('rebuild', QUERY_ARRAY)) {
			$result = rebuild_files($file_record['file_id']);
			redirect('view/' . $file_record['file_id']);
		}

		# remove file
		elseif (array_key_exists('remove', QUERY_ARRAY)) {
			if (array_key_exists('confirm', QUERY_ARRAY)) {
				remove_files($file_record['file_id']);
				redirect('search');
			}
			return render_page_header('Remove file', 'remove-file') . '
				<h2>Really remove file?</h2>
				<p>This can\'t be undone.</p>
				<div>
					<a href="' . THALASSA_URI . 'view/' . $file_id . '?remove&confirm"><input id="remove-file" type="button" value="Remove"/></a>
				</div>' . PAGE_FOOTER;
		}

		$res .= '
			</section>
			<section id="section-edit-file">
				<h2>Edit</h2>
				<form method="POST">
					<label for="tags">Tags</label> 
					<input id="tags" name="tags" type="text" placeholder="#tag #another tag" value="';
		if (!empty($file_record['tags'])) {
			foreach ($file_record['tags'] as $tag) {
				$res .= '#' . str_replace('"', '&quot;', trim($tag)) . ' ';
			}
			$res = substr($res, 0, -1);
		}
		$res .= '"/>
					<br/>
					<!-- input id="comma-separated-tags" name="comma_separated_tags" type="checkbox"/> 
					<label for="comma-separated-tags">Comma-separated tags</label>
					<br/ -->
					<input type="submit" value="Update"/>
					<input id="file-id" name="file_id" type="hidden" value="' . $file_record['file_id'] . '"/>
				</form>
				<form method="POST">
					<label for="datetime">Publish datetime</label> 
					<input id="datetime" name="datetime" type="text" value="' . render_atom_time($file_record['publish_time']) . '" placeholder="Leave blank for current"/>
					<br/>
					<input type="submit" value="Update"/>
					<input id="file-id" name="file_id" type="hidden" value="' . $file_record['file_id'] . '"/>
				</form>
				<form>
					<a href="' . THALASSA_URI . 'view/' . $file_record['file_id'] . '?rebuild"><input id="rebuild" type="button" value="Rebuild"/></a>
				</form>
				<form>
					<a href="' . THALASSA_URI . 'view/' . $file_record['file_id'] . '?remove"><input id="remove-file" type="button" value="Remove"/></a>
				</form>';
	}
	if ('helper' == TOKEN_MODE) {
		# only add tags
		if ('POST' == $_SERVER['REQUEST_METHOD']) {
			$result = [-1, ['Unknown error']];
			if (array_key_exists('add_tags', $_POST)) {
				$tags_string = '';
				if ('' != $_POST['add_tags']) {
					$tags_string = $_POST['add_tags'];
				}
				$comma_separated_tags = false;
				if (array_key_exists('comma_separated_tags', $_POST) && '' != $_POST['comma_separated_tags']) {
					$comma_separated_tags = true;
				}
				$result = edit_files_tags($file_record['file_id'], 'add', $tags_string, $comma_separated_tags);
			}
			elseif (array_key_exists('datetime', $_POST)) {
				$result = set_publish_time($file_record['file_id'], $_POST['datetime']);
			}
			list($result_code, $result_output) = $result;
			if (0 == $result_code) {
				redirect('view/' . $file_record['file_id']);
			}
			$res .= render_result_output_errors($result_output);
		}
		$res .= '
			</section>
			<section id="section-edit-file">
				<h2>Edit</h2>
				<form method="POST">
					<label for="tags">Add tags</label> 
					<input id="add-tags" name="add_tags" type="text" placeholder="#tag #another tag" value=""/>
					<br/>
					<!-- input id="comma-separated-tags" name="comma_separated_tags" type="checkbox"/> 
					<label for="comma-separated-tags">Comma-separated tags</label>
					<br/ -->
					<input type="submit" value="Add tags"/>
					<input id="file-id" name="file_id" type="hidden" value="' . $file_record['file_id'] . '"/>
				</form>';
	}
	return $res . PAGE_FOOTER;
}
 ?>